/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.display.editor.tool;

import me.m56738.easyarmorstands.EasyArmorStandsPlugin;
import me.m56738.easyarmorstands.api.Axis;
import me.m56738.easyarmorstands.api.editor.Snapper;
import me.m56738.easyarmorstands.api.editor.tool.AxisScaleTool;
import me.m56738.easyarmorstands.api.editor.tool.AxisScaleToolSession;
import me.m56738.easyarmorstands.api.editor.tool.ToolContext;
import me.m56738.easyarmorstands.api.property.Property;
import me.m56738.easyarmorstands.api.property.PropertyContainer;
import me.m56738.easyarmorstands.display.api.property.type.DisplayPropertyTypes;
import me.m56738.easyarmorstands.editor.tool.AbstractToolSession;
import me.m56738.easyarmorstands.lib.joml.Quaterniondc;
import me.m56738.easyarmorstands.lib.joml.Vector3dc;
import me.m56738.easyarmorstands.lib.joml.Vector3f;
import me.m56738.easyarmorstands.lib.joml.Vector3fc;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.TextComponent;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.format.TextColor;
import me.m56738.easyarmorstands.message.Message;
import me.m56738.easyarmorstands.util.Util;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisplayAxisScaleTool
implements AxisScaleTool {
    private final ToolContext context;
    private final PropertyContainer properties;
    private final Property<Vector3fc> scaleProperty;
    private final Axis axis;

    public DisplayAxisScaleTool(ToolContext context, PropertyContainer properties, Axis axis) {
        this.context = context;
        this.properties = properties;
        this.scaleProperty = properties.get(DisplayPropertyTypes.SCALE);
        this.axis = axis;
    }

    @Override
    @NotNull
    public Vector3dc getPosition() {
        return this.context.position().getPosition();
    }

    @Override
    @NotNull
    public Quaterniondc getRotation() {
        return this.context.rotation().getRotation();
    }

    @Override
    @NotNull
    public Axis getAxis() {
        return this.axis;
    }

    @Override
    @NotNull
    public AxisScaleToolSession start() {
        return new SessionImpl();
    }

    @Override
    public boolean canUse(@NotNull Player player) {
        return this.scaleProperty.canChange(player);
    }

    private class SessionImpl
    extends AbstractToolSession
    implements AxisScaleToolSession {
        private final Vector3fc originalScale;

        public SessionImpl() {
            super(DisplayAxisScaleTool.this.properties);
            this.originalScale = new Vector3f((Vector3fc)DisplayAxisScaleTool.this.scaleProperty.getValue());
        }

        @Override
        public void setChange(double change) {
            Vector3f scaleVector = new Vector3f(this.originalScale);
            DisplayAxisScaleTool.this.axis.setValue(scaleVector, EasyArmorStandsPlugin.getInstance().getConfiguration().limits.displayEntity.clampScale(DisplayAxisScaleTool.this.axis.getValue(scaleVector) * (float)change));
            DisplayAxisScaleTool.this.scaleProperty.setValue(scaleVector);
        }

        @Override
        public double snapChange(double change, @NotNull Snapper context) {
            float original = DisplayAxisScaleTool.this.axis.getValue(this.originalScale);
            change *= (double)original;
            change = context.snapOffset(change);
            return change /= (double)original;
        }

        @Override
        public void setValue(double value) {
            Vector3f scaleVector = new Vector3f(this.originalScale);
            DisplayAxisScaleTool.this.axis.setValue(scaleVector, EasyArmorStandsPlugin.getInstance().getConfiguration().limits.displayEntity.clampScale((float)value));
            DisplayAxisScaleTool.this.scaleProperty.setValue(scaleVector);
        }

        @Override
        public void revert() {
            DisplayAxisScaleTool.this.scaleProperty.setValue(this.originalScale);
        }

        @Override
        @Nullable
        public Component getStatus() {
            return Component.text(Util.SCALE_FORMAT.format(DisplayAxisScaleTool.this.axis.getValue((Vector3fc)DisplayAxisScaleTool.this.scaleProperty.getValue())));
        }

        @Override
        @Nullable
        public Component getDescription() {
            TextComponent axisName = Component.text(DisplayAxisScaleTool.this.axis.getName(), TextColor.color(DisplayAxisScaleTool.this.axis.getColor()));
            return Message.component("easyarmorstands.history.scale-axis", axisName);
        }
    }
}

