/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.display.command;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.m56738.easyarmorstands.api.ArmorStandPart;
import me.m56738.easyarmorstands.api.ArmorStandSize;
import me.m56738.easyarmorstands.api.editor.Session;
import me.m56738.easyarmorstands.api.editor.node.ElementSelectionNode;
import me.m56738.easyarmorstands.api.element.Element;
import me.m56738.easyarmorstands.api.element.EntityElement;
import me.m56738.easyarmorstands.api.property.Property;
import me.m56738.easyarmorstands.api.property.PropertyContainer;
import me.m56738.easyarmorstands.api.property.PropertyMap;
import me.m56738.easyarmorstands.api.property.type.EntityPropertyTypes;
import me.m56738.easyarmorstands.command.SessionCommands;
import me.m56738.easyarmorstands.command.annotation.PropertyPermission;
import me.m56738.easyarmorstands.command.requirement.RequireElement;
import me.m56738.easyarmorstands.command.requirement.RequireElementSelection;
import me.m56738.easyarmorstands.command.sender.EasPlayer;
import me.m56738.easyarmorstands.command.util.ElementSelection;
import me.m56738.easyarmorstands.context.ChangeContext;
import me.m56738.easyarmorstands.display.DisplayAddon;
import me.m56738.easyarmorstands.display.api.property.type.BlockDisplayPropertyTypes;
import me.m56738.easyarmorstands.display.api.property.type.DisplayPropertyTypes;
import me.m56738.easyarmorstands.display.api.property.type.ItemDisplayPropertyTypes;
import me.m56738.easyarmorstands.display.api.property.type.TextDisplayPropertyTypes;
import me.m56738.easyarmorstands.display.editor.node.DisplayBoxNode;
import me.m56738.easyarmorstands.display.editor.node.DisplayShearNode;
import me.m56738.easyarmorstands.display.element.DisplayElement;
import me.m56738.easyarmorstands.display.element.DisplayElementType;
import me.m56738.easyarmorstands.element.ArmorStandElement;
import me.m56738.easyarmorstands.element.SimpleEntityElement;
import me.m56738.easyarmorstands.group.Group;
import me.m56738.easyarmorstands.group.node.GroupRootNode;
import me.m56738.easyarmorstands.history.action.Action;
import me.m56738.easyarmorstands.history.action.ElementCreateAction;
import me.m56738.easyarmorstands.history.action.ElementDestroyAction;
import me.m56738.easyarmorstands.lib.cloud.annotation.specifier.Greedy;
import me.m56738.easyarmorstands.lib.cloud.annotation.specifier.Range;
import me.m56738.easyarmorstands.lib.cloud.annotations.Argument;
import me.m56738.easyarmorstands.lib.cloud.annotations.Command;
import me.m56738.easyarmorstands.lib.cloud.annotations.CommandDescription;
import me.m56738.easyarmorstands.lib.cloud.annotations.Permission;
import me.m56738.easyarmorstands.lib.cloud.minecraft.extras.annotation.specifier.Decoder;
import me.m56738.easyarmorstands.lib.joml.Matrix4d;
import me.m56738.easyarmorstands.lib.joml.Matrix4dc;
import me.m56738.easyarmorstands.lib.joml.Quaternionf;
import me.m56738.easyarmorstands.lib.joml.Vector3d;
import me.m56738.easyarmorstands.lib.joml.Vector3f;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.format.TextColor;
import me.m56738.easyarmorstands.message.Message;
import me.m56738.easyarmorstands.property.TrackedPropertyContainer;
import me.m56738.easyarmorstands.util.ArmorStandPartInfo;
import me.m56738.easyarmorstands.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Display;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.util.EulerAngle;

@Command(value="eas")
public class DisplayCommands {
    private final DisplayAddon addon;

    public DisplayCommands(DisplayAddon addon) {
        this.addon = addon;
    }

    @Command(value="block <value>")
    @PropertyPermission(value="easyarmorstands:block_display/block")
    @CommandDescription(value="easyarmorstands.command.description.block")
    @RequireElementSelection
    public void setBlock(EasPlayer sender, ElementSelection selection, @Argument(value="value") BlockData value) {
        PropertyContainer properties = selection.properties(sender);
        Property<BlockData> property = properties.getOrNull(BlockDisplayPropertyTypes.BLOCK);
        if (property == null) {
            sender.sendMessage(Message.error("easyarmorstands.error.block-unsupported"));
            return;
        }
        if (property.setValue(value)) {
            properties.commit();
            sender.sendMessage(Message.success("easyarmorstands.success.changed-block", property.getType().getValueComponent(value)));
        } else {
            sender.sendMessage(Message.error("easyarmorstands.error.cannot-change"));
        }
    }

    @Command(value="brightness block <value>")
    @PropertyPermission(value="easyarmorstands:display/brightness")
    @CommandDescription(value="easyarmorstands.command.description.brightness.block")
    @RequireElementSelection
    public void setBlockBrightness(EasPlayer sender, ElementSelection selection, @Argument(value="value") @Range(min="0", max="15") int blockLight) {
        PropertyContainer properties = selection.properties(sender);
        Location location = properties.get(EntityPropertyTypes.LOCATION).getValue();
        Property<Optional<Display.Brightness>> property = properties.getOrNull(DisplayPropertyTypes.BRIGHTNESS);
        if (property == null) {
            sender.sendMessage(Message.error("easyarmorstands.error.brightness-unsupported"));
            return;
        }
        int skyLight = property.getValue().map(Display.Brightness::getSkyLight).orElseGet(() -> location.getBlock().getLightFromSky());
        Optional<Display.Brightness> brightness = Optional.of(new Display.Brightness(blockLight, skyLight));
        if (property.setValue(brightness)) {
            properties.commit();
            sender.sendMessage(Message.success("easyarmorstands.success.changed-brightness", property.getType().getValueComponent(brightness)));
        } else {
            sender.sendMessage(Message.error("easyarmorstands.error.cannot-change"));
        }
    }

    @Command(value="brightness sky <value>")
    @PropertyPermission(value="easyarmorstands:display/brightness")
    @CommandDescription(value="easyarmorstands.command.description.brightness.sky")
    @RequireElementSelection
    public void setSkyBrightness(EasPlayer sender, ElementSelection selection, @Argument(value="value") @Range(min="0", max="15") int skyLight) {
        PropertyContainer properties = selection.properties(sender);
        Location location = properties.get(EntityPropertyTypes.LOCATION).getValue();
        Property<Optional<Display.Brightness>> property = properties.getOrNull(DisplayPropertyTypes.BRIGHTNESS);
        if (property == null) {
            sender.sendMessage(Message.error("easyarmorstands.error.brightness-unsupported"));
            return;
        }
        int blockLight = property.getValue().map(Display.Brightness::getSkyLight).orElseGet(() -> location.getBlock().getLightFromBlocks());
        Optional<Display.Brightness> brightness = Optional.of(new Display.Brightness(blockLight, skyLight));
        if (property.setValue(brightness)) {
            properties.commit();
            sender.sendMessage(Message.success("easyarmorstands.success.changed-brightness", property.getType().getValueComponent(brightness)));
        } else {
            sender.sendMessage(Message.error("easyarmorstands.error.cannot-change"));
        }
    }

    @Command(value="brightness here")
    @PropertyPermission(value="easyarmorstands:display/brightness")
    @CommandDescription(value="easyarmorstands.command.description.brightness.here")
    @RequireElementSelection
    public void setLocalBrightness(EasPlayer sender, ElementSelection selection) {
        PropertyContainer properties = selection.properties(sender);
        Property<Optional<Display.Brightness>> property = properties.getOrNull(DisplayPropertyTypes.BRIGHTNESS);
        if (property == null) {
            sender.sendMessage(Message.error("easyarmorstands.error.brightness-unsupported"));
            return;
        }
        Block block = sender.get().getLocation().getBlock();
        Optional<Display.Brightness> brightness = Optional.of(new Display.Brightness((int)block.getLightFromBlocks(), (int)block.getLightFromSky()));
        if (property.setValue(brightness)) {
            properties.commit();
            sender.sendMessage(Message.success("easyarmorstands.success.changed-brightness", property.getType().getValueComponent(brightness)));
        } else {
            sender.sendMessage(Message.error("easyarmorstands.error.cannot-change"));
        }
    }

    @Command(value="brightness reset")
    @PropertyPermission(value="easyarmorstands:display/brightness")
    @CommandDescription(value="easyarmorstands.command.description.brightness.reset")
    @RequireElementSelection
    public void setDefaultBrightness(EasPlayer sender, ElementSelection selection) {
        PropertyContainer properties = selection.properties(sender);
        Property<Optional<Display.Brightness>> property = properties.getOrNull(DisplayPropertyTypes.BRIGHTNESS);
        if (property == null) {
            sender.sendMessage(Message.error("easyarmorstands.error.brightness-unsupported"));
            return;
        }
        if (property.setValue(Optional.empty())) {
            properties.commit();
            sender.sendMessage(Message.success("easyarmorstands.success.changed-brightness", property.getType().getValueComponent(Optional.empty())));
        } else {
            sender.sendMessage(Message.error("easyarmorstands.error.cannot-change"));
        }
    }

    @Command(value="box width <width>")
    @PropertyPermission(value="easyarmorstands:display/box/width")
    @CommandDescription(value="easyarmorstands.command.description.box.width")
    @RequireElementSelection
    public void setBoxWidth(EasPlayer sender, ElementSelection selection, @Argument(value="width") float value) {
        PropertyContainer properties = selection.properties(sender);
        Property<Float> widthProperty = properties.getOrNull(DisplayPropertyTypes.BOX_WIDTH);
        if (widthProperty == null) {
            sender.sendMessage(Message.error("easyarmorstands.error.box-unsupported"));
            return;
        }
        if (widthProperty.setValue(Float.valueOf(value))) {
            Property<Float> heightProperty = properties.getOrNull(DisplayPropertyTypes.BOX_HEIGHT);
            if (heightProperty != null && heightProperty.getValue().floatValue() == 0.0f) {
                heightProperty.setValue(Float.valueOf(value));
            }
            properties.commit();
            sender.sendMessage(Message.success("easyarmorstands.success.changed-box-width", widthProperty.getType().getValueComponent(Float.valueOf(value))));
        } else {
            sender.sendMessage(Message.error("easyarmorstands.error.cannot-change"));
        }
    }

    @Command(value="box height <height>")
    @PropertyPermission(value="easyarmorstands:display/box/height")
    @CommandDescription(value="easyarmorstands.command.description.box.height")
    @RequireElementSelection
    public void setBoxHeight(EasPlayer sender, ElementSelection selection, @Argument(value="height") float value) {
        PropertyContainer properties = selection.properties(sender);
        Property<Float> heightProperty = properties.getOrNull(DisplayPropertyTypes.BOX_HEIGHT);
        if (heightProperty == null) {
            sender.sendMessage(Message.error("easyarmorstands.error.box-unsupported"));
            return;
        }
        if (heightProperty.setValue(Float.valueOf(value))) {
            Property<Float> widthProperty = properties.getOrNull(DisplayPropertyTypes.BOX_WIDTH);
            if (widthProperty != null && widthProperty.getValue().floatValue() == 0.0f) {
                widthProperty.setValue(Float.valueOf(value));
            }
            properties.commit();
            sender.sendMessage(Message.success("easyarmorstands.success.changed-box-height", heightProperty.getType().getValueComponent(Float.valueOf(value))));
        } else {
            sender.sendMessage(Message.error("easyarmorstands.error.cannot-change"));
        }
    }

    @Command(value="box remove")
    @PropertyPermission(value="easyarmorstands:display/box/height")
    @CommandDescription(value="easyarmorstands.command.description.box.remove")
    @RequireElementSelection
    public void removeBox(EasPlayer sender, ElementSelection selection) {
        PropertyContainer properties = selection.properties(sender);
        int success = 0;
        Property<Float> widthProperty = properties.getOrNull(DisplayPropertyTypes.BOX_WIDTH);
        Property<Float> heightProperty = properties.getOrNull(DisplayPropertyTypes.BOX_HEIGHT);
        if (widthProperty == null && heightProperty == null) {
            sender.sendMessage(Message.error("easyarmorstands.error.box-unsupported"));
            return;
        }
        if (widthProperty != null && widthProperty.setValue(Float.valueOf(0.0f))) {
            ++success;
        }
        if (heightProperty != null && heightProperty.setValue(Float.valueOf(0.0f))) {
            ++success;
        }
        if (success > 0) {
            properties.commit();
            sender.sendMessage(Message.success("easyarmorstands.success.removed-box"));
        } else {
            sender.sendMessage(Message.error("easyarmorstands.error.cannot-change"));
        }
    }

    @Command(value="box")
    @PropertyPermission(value="easyarmorstands:display/translation")
    @CommandDescription(value="easyarmorstands.command.description.box")
    @RequireElement
    public void moveBox(EasPlayer sender, Session session, Element element) {
        if (!(element instanceof DisplayElement)) {
            sender.sendMessage(Message.error("easyarmorstands.error.box-unsupported"));
            return;
        }
        TrackedPropertyContainer properties = new TrackedPropertyContainer(element, sender);
        session.pushNode(new DisplayBoxNode(session, properties));
    }

    @Command(value="text")
    @PropertyPermission(value="easyarmorstands:text_display/text")
    @CommandDescription(value="easyarmorstands.command.description.text")
    @RequireElement
    public void showText(EasPlayer sender, Element element) {
        Property<Component> property = element.getProperties().getOrNull(TextDisplayPropertyTypes.TEXT);
        if (property == null) {
            sender.sendMessage(Message.error("easyarmorstands.error.text-unsupported"));
            return;
        }
        Component text = property.getValue();
        SessionCommands.showText(sender, TextDisplayPropertyTypes.TEXT.getName(), text, "/eas text set");
    }

    @Command(value="text set <value>")
    @PropertyPermission(value="easyarmorstands:text_display/text")
    @CommandDescription(value="easyarmorstands.command.description.text.set")
    @RequireElementSelection
    public void setText(EasPlayer sender, ElementSelection selection, @Argument(value="value") @Decoder.MiniMessage @Greedy Component value) {
        PropertyContainer properties = selection.properties(sender);
        Property<Component> property = properties.getOrNull(TextDisplayPropertyTypes.TEXT);
        if (property == null) {
            sender.sendMessage(Message.error("easyarmorstands.error.text-unsupported"));
            return;
        }
        if (property.setValue(value)) {
            properties.commit();
            sender.sendMessage(Message.success("easyarmorstands.success.changed-text", property.getType().getValueComponent(value)));
        } else {
            sender.sendMessage(Message.error("easyarmorstands.error.cannot-change"));
        }
    }

    @Command(value="text width <value>")
    @PropertyPermission(value="easyarmorstands:text_display/line_width")
    @CommandDescription(value="easyarmorstands.command.description.text.width")
    @RequireElementSelection
    public void setTextWidth(EasPlayer sender, ElementSelection selection, @Argument(value="value") int value) {
        PropertyContainer properties = selection.properties(sender);
        Property<Integer> property = properties.getOrNull(TextDisplayPropertyTypes.LINE_WIDTH);
        if (property == null) {
            sender.sendMessage(Message.error("easyarmorstands.error.text-line-width-unsupported"));
            return;
        }
        if (property.setValue(value)) {
            properties.commit();
            sender.sendMessage(Message.success("easyarmorstands.success.changed-text-line-width", property.getType().getValueComponent(value)));
        } else {
            sender.sendMessage(Message.error("easyarmorstands.error.cannot-change"));
        }
    }

    @Command(value="text background color <value>")
    @PropertyPermission(value="easyarmorstands:text_display/background")
    @CommandDescription(value="easyarmorstands.command.description.text.background.color")
    @RequireElementSelection
    public void setTextBackground(EasPlayer sender, ElementSelection selection, @Argument(value="value") TextColor color) {
        PropertyContainer properties = selection.properties(sender);
        Property<Optional<Color>> property = properties.getOrNull(TextDisplayPropertyTypes.BACKGROUND);
        if (property == null) {
            sender.sendMessage(Message.error("easyarmorstands.error.text-background-unsupported"));
            return;
        }
        Optional<Color> value = Optional.of(Color.fromRGB((int)color.value()));
        if (property.setValue(value)) {
            properties.commit();
            sender.sendMessage(Message.success("easyarmorstands.success.changed-text-background", property.getType().getValueComponent(value)));
        } else {
            sender.sendMessage(Message.error("easyarmorstands.error.cannot-change"));
        }
    }

    @Command(value="text background reset")
    @PropertyPermission(value="easyarmorstands:text_display/background")
    @CommandDescription(value="easyarmorstands.command.description.text.background.reset")
    @RequireElementSelection
    public void resetTextBackground(EasPlayer sender, ElementSelection selection) {
        PropertyContainer properties = selection.properties(sender);
        Property<Optional<Color>> property = properties.getOrNull(TextDisplayPropertyTypes.BACKGROUND);
        if (property == null) {
            sender.sendMessage(Message.error("easyarmorstands.error.text-background-unsupported"));
            return;
        }
        if (property.setValue(Optional.empty())) {
            properties.commit();
            sender.sendMessage(Message.success("easyarmorstands.success.changed-text-background", property.getType().getValueComponent(Optional.empty())));
        } else {
            sender.sendMessage(Message.error("easyarmorstands.error.cannot-change"));
        }
    }

    @Command(value="text background none")
    @PropertyPermission(value="easyarmorstands:text_display/background")
    @CommandDescription(value="easyarmorstands.command.description.text.background.none")
    @RequireElementSelection
    public void hideTextBackground(EasPlayer sender, ElementSelection selection) {
        PropertyContainer properties = selection.properties(sender);
        Property<Optional<Color>> property = properties.getOrNull(TextDisplayPropertyTypes.BACKGROUND);
        if (property == null) {
            sender.sendMessage(Message.error("easyarmorstands.error.text-background-unsupported"));
            return;
        }
        Optional<Color> value = Optional.of(Color.fromARGB((int)0));
        if (property.setValue(value)) {
            properties.commit();
            sender.sendMessage(Message.success("easyarmorstands.success.changed-text-background", property.getType().getValueComponent(value)));
        } else {
            sender.sendMessage(Message.error("easyarmorstands.error.cannot-change"));
        }
    }

    @Command(value="text background alpha <value>")
    @PropertyPermission(value="easyarmorstands:text_display/background")
    @CommandDescription(value="easyarmorstands.command.description.text.background.alpha")
    @RequireElementSelection
    public void hideTextBackground(EasPlayer sender, ElementSelection selection, @Argument(value="value") @Range(min="0", max="255") int alpha) {
        PropertyContainer properties = selection.properties(sender);
        Property<Optional<Color>> property = properties.getOrNull(TextDisplayPropertyTypes.BACKGROUND);
        if (property == null) {
            sender.sendMessage(Message.error("easyarmorstands.error.text-background-unsupported"));
            return;
        }
        Optional<Color> oldValue = property.getValue();
        if (!oldValue.isPresent()) {
            sender.sendMessage(Message.error("easyarmorstands.error.cannot-change"));
            return;
        }
        Optional<Color> value = oldValue.map(v -> v.setAlpha(alpha));
        if (property.setValue(value)) {
            properties.commit();
            sender.sendMessage(Message.success("easyarmorstands.success.changed-text-background-alpha", Component.text(alpha)));
        } else {
            sender.sendMessage(Message.error("easyarmorstands.error.cannot-change"));
        }
    }

    @Command(value="glow color <value>")
    @PropertyPermission(value="easyarmorstands:display/glowing/color")
    @CommandDescription(value="easyarmorstands.command.description.glow.color")
    @RequireElementSelection
    public void setGlowColor(EasPlayer sender, ElementSelection selection, @Argument(value="value") TextColor color) {
        PropertyContainer properties = selection.properties(sender);
        Property<Optional<Color>> property = properties.getOrNull(DisplayPropertyTypes.GLOW_COLOR);
        if (property == null) {
            sender.sendMessage(Message.error("easyarmorstands.error.glow-color-unsupported"));
            return;
        }
        Optional<Color> value = Optional.of(Color.fromRGB((int)color.value()));
        if (property.setValue(value)) {
            properties.commit();
            sender.sendMessage(Message.success("easyarmorstands.success.changed-glow-color", property.getType().getValueComponent(value)));
        } else {
            sender.sendMessage(Message.error("easyarmorstands.error.cannot-change"));
        }
    }

    @Command(value="glow reset")
    @PropertyPermission(value="easyarmorstands:display/glowing/color")
    @CommandDescription(value="easyarmorstands.command.description.glow.color.reset")
    @RequireElementSelection
    public void resetGlowColor(EasPlayer sender, ElementSelection selection) {
        PropertyContainer properties = selection.properties(sender);
        Property<Optional<Color>> property = properties.getOrNull(DisplayPropertyTypes.GLOW_COLOR);
        if (property == null) {
            sender.sendMessage(Message.error("easyarmorstands.error.glow-color-unsupported"));
            return;
        }
        Optional value = Optional.empty();
        if (property.setValue(value)) {
            properties.commit();
            sender.sendMessage(Message.success("easyarmorstands.success.changed-glow-color", property.getType().getValueComponent(value)));
        } else {
            sender.sendMessage(Message.error("easyarmorstands.error.cannot-change"));
        }
    }

    @Command(value="shear")
    @PropertyPermission(value="easyarmorstands:display/right_rotation")
    @CommandDescription(value="easyarmorstands.command.description.shear")
    @RequireElement
    public void editRightRotation(EasPlayer sender, Session session, Element element) {
        if (!(element instanceof DisplayElement)) {
            sender.sendMessage(Message.error("easyarmorstands.error.shearing-unsupported"));
            return;
        }
        TrackedPropertyContainer properties = new TrackedPropertyContainer(element, sender);
        DisplayShearNode node = new DisplayShearNode(session, properties, (DisplayElement)element);
        session.pushNode(node);
    }

    @Command(value="convert")
    @Permission(value={"easyarmorstands.convert"})
    @CommandDescription(value="easyarmorstands.command.description.convert")
    @RequireElementSelection
    public void convert(EasPlayer sender, Session session, ElementSelection selection) {
        ArrayList<SimpleEntityElement<ItemDisplay>> createdElements = new ArrayList<SimpleEntityElement<ItemDisplay>>();
        ArrayList<Action> allActions = new ArrayList<Action>();
        boolean foundArmorStand = false;
        int count = 0;
        boolean isInverted = Bukkit.getBukkitVersion().equals("1.19.4-R0.1-SNAPSHOT");
        for (Element element : selection.elements()) {
            if (!(element instanceof ArmorStandElement)) continue;
            foundArmorStand = true;
            ArmorStand entity = (ArmorStand)((ArmorStandElement)element).getEntity();
            EntityEquipment equipment = entity.getEquipment();
            if (equipment == null) continue;
            Matrix4d matrix4d = new Matrix4d();
            Matrix4d rightMatrix = new Matrix4d();
            Matrix4d leftMatrix = new Matrix4d();
            if (entity.isSmall()) {
                matrix4d.scale(0.7);
                rightMatrix.scale(0.5);
                leftMatrix.scale(0.5);
            }
            if (this.isSkull(equipment.getHelmet())) {
                matrix4d.scale(1.1875);
                matrix4d.translate(0.0, 0.5, 0.0);
                matrix4d.rotateY(Math.PI);
            } else {
                matrix4d.translate(0.0, 0.25, 0.0);
                matrix4d.scale(0.625);
            }
            rightMatrix.translate(-0.0625, -0.625, 0.125);
            rightMatrix.rotateX(1.5707963267948966);
            leftMatrix.translate(0.0625, -0.625, 0.125);
            leftMatrix.rotateX(1.5707963267948966);
            if (isInverted) {
                matrix4d.rotateY(Math.PI);
                rightMatrix.rotateY(Math.PI);
                leftMatrix.rotateY(Math.PI);
            }
            ArrayList<Action> actions = new ArrayList<Action>();
            this.convert(sender, entity, equipment.getHelmet(), ArmorStandPart.HEAD, ItemDisplay.ItemDisplayTransform.HEAD, matrix4d, actions, createdElements);
            this.convert(sender, entity, equipment.getItemInMainHand(), ArmorStandPart.RIGHT_ARM, ItemDisplay.ItemDisplayTransform.THIRDPERSON_RIGHTHAND, rightMatrix, actions, createdElements);
            this.convert(sender, entity, equipment.getItemInOffHand(), ArmorStandPart.LEFT_ARM, ItemDisplay.ItemDisplayTransform.THIRDPERSON_LEFTHAND, leftMatrix, actions, createdElements);
            if (!actions.isEmpty()) {
                actions.add(new ElementDestroyAction(element));
                entity.remove();
                ++count;
            }
            allActions.addAll(actions);
        }
        sender.history().push(allActions, Message.component("easyarmorstands.history.converted-armor-stand"));
        if (!foundArmorStand) {
            sender.sendMessage(Message.error("easyarmorstands.error.convert-unsupported"));
        } else if (count == 0) {
            sender.sendMessage(Message.error("easyarmorstands.error.cannot-convert"));
        } else if (count == 1) {
            sender.sendMessage(Message.success("easyarmorstands.success.armor-stand-converted"));
        } else {
            sender.sendMessage(Message.success("easyarmorstands.success.armor-stand-converted.multiple", Component.text(count)));
        }
        GroupRootNode groupRootNode = session.findNode(GroupRootNode.class);
        if (groupRootNode != null) {
            Group group = groupRootNode.getGroup();
            session.returnToNode(groupRootNode);
            EasPlayer context = new EasPlayer(session.player());
            for (SimpleEntityElement simpleEntityElement : createdElements) {
                if (!context.canEditElement(simpleEntityElement)) continue;
                group.addMember(simpleEntityElement);
            }
        } else {
            ElementSelectionNode selectionNode = session.findNode(ElementSelectionNode.class);
            if (selectionNode != null) {
                selectionNode.selectElements(createdElements);
            }
        }
    }

    private boolean isSkull(ItemStack item) {
        return item != null && item.getItemMeta() instanceof SkullMeta;
    }

    private void convert(ChangeContext context, ArmorStand entity, ItemStack item, ArmorStandPart part, ItemDisplay.ItemDisplayTransform itemTransform, Matrix4dc matrix, List<Action> actions, List<SimpleEntityElement<ItemDisplay>> elements) {
        if (item == null || item.getType().isAir()) {
            return;
        }
        ArmorStandPartInfo info = ArmorStandPartInfo.of(part);
        Location location = entity.getLocation();
        Vector3d offset = info.getOffset(ArmorStandSize.get(entity), 1.0).rotateY(Util.getRoundedYawAngle(location.getYaw()), new Vector3d());
        location.add(offset.x, offset.y, offset.z);
        EulerAngle angle = part.getPose(entity);
        Matrix4d transform = new Matrix4d().rotateY(Util.getRoundedYawAngle(location.getYaw())).rotateZYX(-angle.getZ(), -angle.getY(), angle.getX()).mul(matrix);
        location.setYaw(0.0f);
        location.setPitch(0.0f);
        PropertyMap properties = new PropertyMap();
        properties.put(EntityPropertyTypes.LOCATION, location);
        properties.put(ItemDisplayPropertyTypes.ITEM, item);
        properties.put(ItemDisplayPropertyTypes.TRANSFORM, itemTransform);
        properties.put(DisplayPropertyTypes.TRANSLATION, transform.getTranslation(new Vector3d()).get(new Vector3f()));
        properties.put(DisplayPropertyTypes.LEFT_ROTATION, transform.getUnnormalizedRotation(new Quaternionf()));
        properties.put(DisplayPropertyTypes.SCALE, transform.getScale(new Vector3d()).get(new Vector3f()));
        DisplayElementType<ItemDisplay> type = this.addon.getItemDisplayType();
        if (!context.canCreateElement(type, properties)) {
            return;
        }
        EntityElement element = type.createElement(properties);
        if (element == null) {
            return;
        }
        actions.add(new ElementCreateAction(element));
        elements.add((SimpleEntityElement<ItemDisplay>)element);
    }

    @Command(value="viewrange <value>")
    @PropertyPermission(value="easyarmorstands:display/view_range")
    @CommandDescription(value="easyarmorstands.command.description.view-range")
    @RequireElementSelection
    public void setViewRange(EasPlayer sender, ElementSelection selection, @Argument(value="value") float value) {
        PropertyContainer properties = selection.properties(sender);
        Property<Float> property = properties.getOrNull(DisplayPropertyTypes.VIEW_RANGE);
        if (property == null) {
            sender.sendMessage(Message.error("easyarmorstands.error.view-range-unsupported"));
            return;
        }
        if (property.setValue(Float.valueOf(value))) {
            properties.commit();
            sender.sendMessage(Message.success("easyarmorstands.success.changed-view-range", property.getType().getValueComponent(Float.valueOf(value))));
        } else {
            sender.sendMessage(Message.error("easyarmorstands.error.cannot-change"));
        }
    }
}

