/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.command;

import java.util.Iterator;
import me.m56738.easyarmorstands.command.sender.EasPlayer;
import me.m56738.easyarmorstands.history.History;
import me.m56738.easyarmorstands.history.action.Action;
import me.m56738.easyarmorstands.lib.cloud.annotation.specifier.Range;
import me.m56738.easyarmorstands.lib.cloud.annotations.Argument;
import me.m56738.easyarmorstands.lib.cloud.annotations.Command;
import me.m56738.easyarmorstands.lib.cloud.annotations.CommandDescription;
import me.m56738.easyarmorstands.lib.cloud.annotations.Default;
import me.m56738.easyarmorstands.lib.cloud.annotations.Permission;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.ComponentLike;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.TextComponent;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.format.NamedTextColor;
import me.m56738.easyarmorstands.message.Message;

@Command(value="eas")
public class HistoryCommands {
    @Command(value="history")
    @Permission(value={"easyarmorstands.history"})
    @CommandDescription(value="easyarmorstands.command.description.history")
    public void history(EasPlayer sender) {
        History history = sender.history();
        if (history.getPast().isEmpty()) {
            sender.sendMessage(Message.warning("easyarmorstands.warning.history-empty"));
            return;
        }
        sender.sendMessage(Message.title("easyarmorstands.title.history"));
        Iterator<Action> it = history.getPast().descendingIterator();
        while (it.hasNext()) {
            Action action = it.next();
            sender.sendMessage((ComponentLike)((TextComponent.Builder)Component.text().content("* ").color(NamedTextColor.GRAY)).append(action.describe()));
        }
    }

    @Command(value="redo [count]")
    @Permission(value={"easyarmorstands.redo"})
    @CommandDescription(value="easyarmorstands.command.description.redo")
    public void redo(EasPlayer sender, @Range(min="1", max="10") @Argument(value="count") @Default(value="1") int count) {
        History history = sender.history();
        for (int i = 0; i < count; ++i) {
            Action action = history.takeRedoAction();
            if (action != null) {
                if (!action.execute(sender)) {
                    sender.sendMessage(Message.error("easyarmorstands.error.cannot-redo", action.describe()));
                    break;
                }
            } else {
                sender.sendMessage(Message.error("easyarmorstands.error.nothing-to-redo"));
                break;
            }
            sender.sendMessage(Message.success("easyarmorstands.success.redone-change", action.describe()));
        }
    }

    @Command(value="undo [count]")
    @Permission(value={"easyarmorstands.undo"})
    @CommandDescription(value="easyarmorstands.command.description.undo")
    public void undo(EasPlayer sender, @Range(min="1", max="10") @Argument(value="count") @Default(value="1") int count) {
        History history = sender.history();
        for (int i = 0; i < count; ++i) {
            Action action = history.takeUndoAction();
            if (action != null) {
                if (!action.undo(sender)) {
                    sender.sendMessage(Message.error("easyarmorstands.error.cannot-undo", action.describe()));
                    break;
                }
            } else {
                sender.sendMessage(Message.error("easyarmorstands.error.nothing-to-undo"));
                break;
            }
            sender.sendMessage(Message.success("easyarmorstands.success.undone-change", action.describe()));
        }
    }
}

