/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.api.editor.tool;

import me.m56738.easyarmorstands.api.Axis;
import me.m56738.easyarmorstands.api.editor.tool.AxisMoveTool;
import me.m56738.easyarmorstands.api.editor.tool.AxisRotateTool;
import me.m56738.easyarmorstands.api.editor.tool.AxisScaleTool;
import me.m56738.easyarmorstands.api.editor.tool.MoveTool;
import me.m56738.easyarmorstands.api.editor.tool.ScaleTool;
import me.m56738.easyarmorstands.api.editor.tool.SimpleAxisMoveTool;
import me.m56738.easyarmorstands.api.editor.tool.ToolContext;
import me.m56738.easyarmorstands.api.util.PositionProvider;
import me.m56738.easyarmorstands.api.util.RotationProvider;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ToolProvider {
    @Contract(pure=true)
    @NotNull
    public PositionProvider position();

    @Contract(pure=true)
    @NotNull
    public RotationProvider rotation();

    @Nullable
    default public MoveTool move(@NotNull ToolContext context) {
        return this.move(context.position(), context.rotation());
    }

    @Deprecated
    @Contract(pure=true)
    @Nullable
    default public MoveTool move(@NotNull PositionProvider positionProvider, @NotNull RotationProvider rotationProvider) {
        return null;
    }

    @Contract(pure=true)
    @Nullable
    default public AxisMoveTool move(@NotNull ToolContext context, @NotNull Axis axis) {
        MoveTool moveTool = this.move(context);
        if (moveTool != null) {
            return new SimpleAxisMoveTool(moveTool, axis);
        }
        return null;
    }

    @Deprecated
    @Contract(pure=true)
    @Nullable
    default public AxisMoveTool move(@NotNull PositionProvider positionProvider, @NotNull RotationProvider rotationProvider, @NotNull Axis axis) {
        return null;
    }

    @Contract(pure=true)
    @Nullable
    default public AxisRotateTool rotate(@NotNull ToolContext context, @NotNull Axis axis) {
        return this.rotate(context.position(), context.rotation(), axis);
    }

    @Deprecated
    @Contract(pure=true)
    @Nullable
    default public AxisRotateTool rotate(@NotNull PositionProvider positionProvider, @NotNull RotationProvider rotationProvider, @NotNull Axis axis) {
        return null;
    }

    @Contract(pure=true)
    @Nullable
    default public ScaleTool scale(@NotNull ToolContext context) {
        return this.scale(context.position(), context.rotation());
    }

    @Deprecated
    @Contract(pure=true)
    @Nullable
    default public ScaleTool scale(@NotNull PositionProvider positionProvider, @NotNull RotationProvider rotationProvider) {
        return null;
    }

    @Contract(pure=true)
    @Nullable
    default public AxisScaleTool scale(@NotNull ToolContext context, @NotNull Axis axis) {
        return this.scale(context.position(), context.rotation(), axis);
    }

    @Deprecated
    @Contract(pure=true)
    @Nullable
    default public AxisScaleTool scale(@NotNull PositionProvider positionProvider, @NotNull RotationProvider rotationProvider, @NotNull Axis axis) {
        return null;
    }
}

