/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.property.button;

import me.m56738.easyarmorstands.EasyArmorStandsPlugin;
import me.m56738.easyarmorstands.api.menu.MenuClick;
import me.m56738.easyarmorstands.api.property.Property;
import me.m56738.easyarmorstands.api.property.PropertyContainer;
import me.m56738.easyarmorstands.item.SimpleItemTemplate;
import me.m56738.easyarmorstands.message.Message;
import me.m56738.easyarmorstands.property.button.PropertyButton;
import org.jetbrains.annotations.NotNull;

public abstract class ToggleButton<T>
extends PropertyButton<T> {
    public ToggleButton(Property<T> property, PropertyContainer container, SimpleItemTemplate item) {
        super(property, container, item);
    }

    public abstract T getNextValue();

    public abstract T getPreviousValue();

    protected boolean setValue(T value) {
        return this.property.setValue(value);
    }

    @Override
    public void onClick(@NotNull MenuClick click) {
        boolean changed;
        if (click.isShiftClick()) {
            EasyArmorStandsPlugin.getInstance().getClipboard(click.player()).handlePropertyShiftClick(this.property, click);
            return;
        }
        if (click.isLeftClick()) {
            changed = this.setValue(this.getNextValue());
        } else if (click.isRightClick()) {
            changed = this.setValue(this.getPreviousValue());
        } else {
            return;
        }
        if (changed) {
            this.container.commit();
            click.updateItem();
        } else {
            click.sendMessage(Message.error("easyarmorstands.error.cannot-change"));
        }
    }
}

