/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.menu;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import me.m56738.easyarmorstands.api.editor.Session;
import me.m56738.easyarmorstands.api.menu.Menu;
import me.m56738.easyarmorstands.api.menu.MenuClick;
import me.m56738.easyarmorstands.api.menu.MenuClickInterceptor;
import me.m56738.easyarmorstands.api.menu.MenuSlot;
import me.m56738.easyarmorstands.command.sender.EasPlayer;
import me.m56738.easyarmorstands.lib.joml.Matrix4dc;
import me.m56738.easyarmorstands.lib.kyori.adventure.audience.Audience;
import me.m56738.easyarmorstands.util.Util;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.DragType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MenuListener
implements Listener {
    @Nullable
    private final MethodHandle inventoryHolderGetter = MenuListener.findInventoryHolderGetter();

    @Nullable
    private static MethodHandle findInventoryHolderGetter() {
        try {
            return MethodHandles.lookup().findVirtual(Inventory.class, "getHolder", MethodType.methodType(InventoryHolder.class, Boolean.TYPE));
        }
        catch (ReflectiveOperationException e) {
            return null;
        }
    }

    private InventoryHolder getHolder(Inventory inventory) {
        if (this.inventoryHolderGetter == null) {
            return inventory.getHolder();
        }
        try {
            return this.inventoryHolderGetter.invoke(inventory, false);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @EventHandler
    public void onClick(InventoryClickEvent event) {
        InventoryHolder holder = this.getHolder(event.getInventory());
        if (holder instanceof Menu && event.getWhoClicked() instanceof Player) {
            if (event.getRawSlot() >= event.getInventory().getSize()) {
                if (event.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY || event.getAction() == InventoryAction.COLLECT_TO_CURSOR) {
                    event.setCancelled(true);
                }
                return;
            }
            Menu menu = (Menu)holder;
            event.setCancelled(true);
            SingleClick click = new SingleClick(menu, event);
            menu.onClick(click);
            if (click.update) {
                event.setCurrentItem(menu.getItem(event.getSlot()));
            }
        }
    }

    @EventHandler
    public void onDrag(InventoryDragEvent event) {
        InventoryHolder holder = this.getHolder(event.getInventory());
        if (holder instanceof Menu && event.getWhoClicked() instanceof Player) {
            if (event.getRawSlots().size() != 1) {
                event.setCancelled(true);
                return;
            }
            int slot = (Integer)event.getRawSlots().iterator().next();
            if (slot != event.getView().convertSlot(slot)) {
                return;
            }
            Menu menu = (Menu)holder;
            event.setCancelled(true);
            menu.onClick(new DragClick(menu, event, slot));
        }
    }

    private static class SingleClick
    extends Click {
        private final InventoryClickEvent event;
        private boolean update;

        private SingleClick(Menu menu, InventoryClickEvent event) {
            super(menu, (InventoryInteractEvent)event, event.getSlot());
            this.event = event;
        }

        @Override
        public boolean isLeftClick() {
            return this.event.isLeftClick() && this.event.getClick() != ClickType.DOUBLE_CLICK;
        }

        @Override
        public boolean isRightClick() {
            return this.event.isRightClick();
        }

        @Override
        public boolean isShiftClick() {
            return this.event.isShiftClick();
        }

        @Override
        public void updateItem() {
            this.update = true;
        }
    }

    private static class DragClick
    extends Click {
        private final InventoryDragEvent event;

        private DragClick(Menu menu, InventoryDragEvent event, int slot) {
            super(menu, (InventoryInteractEvent)event, slot);
            this.event = event;
        }

        @Override
        public boolean isLeftClick() {
            return this.event.getType() == DragType.EVEN;
        }

        @Override
        public boolean isRightClick() {
            return this.event.getType() == DragType.SINGLE;
        }

        @Override
        public boolean isShiftClick() {
            return false;
        }
    }

    private static abstract class Click
    implements MenuClick {
        private final Menu menu;
        private final MenuSlot slot;
        private final InventoryInteractEvent event;
        private final int index;
        private final EasPlayer player;

        private Click(Menu menu, InventoryInteractEvent event, int index) {
            this.menu = menu;
            this.slot = menu.getSlot(index);
            this.event = event;
            this.index = index;
            this.player = new EasPlayer((Player)event.getWhoClicked());
        }

        @Override
        @NotNull
        public Menu menu() {
            return this.menu;
        }

        @Override
        public MenuSlot slot() {
            return this.slot;
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        @NotNull
        public Player player() {
            return this.player.get();
        }

        @Override
        @NotNull
        public ItemStack cursor() {
            return Util.wrapItem(this.event.getView().getCursor());
        }

        @Override
        @Nullable
        public Session session() {
            return this.player.session();
        }

        @Override
        @NotNull
        public Matrix4dc eyeMatrix() {
            return Util.toMatrix4d(this.player.get().getEyeLocation());
        }

        @Override
        public void allow() {
            this.event.setCancelled(false);
        }

        @Override
        public void open(@NotNull Inventory inventory) {
            this.queueTask(() -> this.player.get().openInventory(inventory));
        }

        @Override
        public void close() {
            this.queueTask(() -> this.menu.close(this.player.get()));
        }

        @Override
        public void updateItem() {
            this.queueTask(() -> this.menu.updateItem(this.index));
        }

        @Override
        public void updateItem(@NotNull MenuSlot slot) {
            this.queueTask(() -> this.menu.updateItem(slot));
        }

        @Override
        public void queueTask(@NotNull Runnable task) {
            this.menu.queueTask(task);
        }

        @Override
        public void interceptNextClick(@NotNull MenuClickInterceptor interceptor) {
            this.menu.interceptNextClick(interceptor);
        }

        @Override
        @NotNull
        public Audience audience() {
            return this.player;
        }
    }
}

