/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.lib.cloud.permission;

import java.util.function.Predicate;
import me.m56738.easyarmorstands.lib.cloud.key.CloudKey;
import me.m56738.easyarmorstands.lib.cloud.permission.PermissionResult;
import me.m56738.easyarmorstands.lib.cloud.permission.PredicatePermission;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

@API(status=API.Status.INTERNAL, consumers={"me.m56738.easyarmorstands.lib.cloud.*"})
final class WrappingPredicatePermission<C>
implements PredicatePermission<C> {
    private final CloudKey<Void> key;
    private final Predicate<C> predicate;

    WrappingPredicatePermission(@NonNull CloudKey<Void> key, @NonNull Predicate<C> predicate) {
        this.key = key;
        this.predicate = predicate;
    }

    @Override
    public @NonNull PermissionResult testPermission(@NonNull C sender) {
        return PermissionResult.of(this.predicate.test(sender), this);
    }

    @Override
    public @NonNull CloudKey<Void> key() {
        return this.key;
    }

    public String toString() {
        return this.key.name();
    }
}

