/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.group.property;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import me.m56738.easyarmorstands.api.property.PendingChange;
import me.m56738.easyarmorstands.api.property.Property;
import me.m56738.easyarmorstands.api.property.type.PropertyType;
import me.m56738.easyarmorstands.group.property.GroupPendingChange;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GroupProperty<T>
implements Property<T> {
    private final PropertyType<T> type;
    private final List<Property<T>> properties = new ArrayList<Property<T>>();

    public GroupProperty(PropertyType<T> type) {
        this.type = type;
    }

    public void addProperty(Property<T> property) {
        this.properties.add(property);
    }

    boolean isEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    @NotNull
    public PropertyType<T> getType() {
        return this.type;
    }

    @Override
    @NotNull
    public T getValue() {
        HashMap<T, Integer> votes = new HashMap<T, Integer>();
        for (Property<T> property : this.properties) {
            votes.merge(property.getValue(), 1, Integer::sum);
        }
        Object best = null;
        int bestVotes = 0;
        for (Map.Entry entry : votes.entrySet()) {
            int n = (Integer)entry.getValue();
            if (n <= bestVotes) continue;
            best = entry.getKey();
            bestVotes = n;
        }
        return Objects.requireNonNull(best);
    }

    @Override
    public boolean setValue(@NotNull T value) {
        boolean changed = false;
        for (Property<T> property : this.properties) {
            if (!property.setValue(value)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    @Nullable
    public PendingChange prepareChange(@NotNull T value) {
        ArrayList<PendingChange> changes = new ArrayList<PendingChange>(this.properties.size());
        for (Property<T> property : this.properties) {
            PendingChange change = property.prepareChange(value);
            if (change == null) continue;
            changes.add(change);
        }
        if (changes.isEmpty()) {
            return null;
        }
        return new GroupPendingChange(changes);
    }

    @Override
    public boolean canChange(@NotNull Player player) {
        for (Property<T> property : this.properties) {
            if (!property.canChange(player)) continue;
            return true;
        }
        return false;
    }
}

