/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.display.editor.tool;

import me.m56738.easyarmorstands.api.Axis;
import me.m56738.easyarmorstands.api.editor.Snapper;
import me.m56738.easyarmorstands.api.editor.tool.AxisRotateTool;
import me.m56738.easyarmorstands.api.editor.tool.AxisRotateToolSession;
import me.m56738.easyarmorstands.api.editor.tool.ToolContext;
import me.m56738.easyarmorstands.api.property.PendingChange;
import me.m56738.easyarmorstands.api.property.Property;
import me.m56738.easyarmorstands.api.property.PropertyContainer;
import me.m56738.easyarmorstands.api.property.type.EntityPropertyTypes;
import me.m56738.easyarmorstands.api.property.type.PropertyType;
import me.m56738.easyarmorstands.api.util.RotationProvider;
import me.m56738.easyarmorstands.display.api.property.type.DisplayPropertyTypes;
import me.m56738.easyarmorstands.editor.tool.AbstractToolSession;
import me.m56738.easyarmorstands.lib.joml.Quaterniond;
import me.m56738.easyarmorstands.lib.joml.Quaterniondc;
import me.m56738.easyarmorstands.lib.joml.Quaternionf;
import me.m56738.easyarmorstands.lib.joml.Quaternionfc;
import me.m56738.easyarmorstands.lib.joml.Vector3d;
import me.m56738.easyarmorstands.lib.joml.Vector3dc;
import me.m56738.easyarmorstands.lib.joml.Vector3f;
import me.m56738.easyarmorstands.lib.joml.Vector3fc;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.TextComponent;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.format.TextColor;
import me.m56738.easyarmorstands.message.Message;
import me.m56738.easyarmorstands.util.Util;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisplayAxisRotateTool
implements AxisRotateTool {
    private final ToolContext context;
    private final PropertyContainer properties;
    private final Property<Location> locationProperty;
    private final Property<Vector3fc> translationProperty;
    private final Property<Quaternionfc> rotationProperty;
    private final Property<Float> heightProperty;
    private final Axis axis;
    private final RotationProvider parentRotationProvider;

    public DisplayAxisRotateTool(ToolContext context, PropertyContainer properties, PropertyType<Quaternionfc> type, Axis axis, RotationProvider parentRotationProvider) {
        this.context = context;
        this.properties = properties;
        this.locationProperty = properties.get(EntityPropertyTypes.LOCATION);
        this.translationProperty = properties.get(DisplayPropertyTypes.TRANSLATION);
        this.heightProperty = properties.get(DisplayPropertyTypes.BOX_HEIGHT);
        this.rotationProperty = properties.get(type);
        this.axis = axis;
        this.parentRotationProvider = parentRotationProvider;
    }

    @Override
    @NotNull
    public Vector3dc getPosition() {
        return this.context.position().getPosition();
    }

    @Override
    @NotNull
    public Quaterniondc getRotation() {
        return this.context.rotation().getRotation();
    }

    @Override
    @NotNull
    public Axis getAxis() {
        return this.axis;
    }

    @Override
    @NotNull
    public AxisRotateToolSession start() {
        return new SessionImpl();
    }

    @Override
    public boolean canUse(@NotNull Player player) {
        return this.rotationProperty.canChange(player) && this.locationProperty.canChange(player) && this.translationProperty.canChange(player);
    }

    private class SessionImpl
    extends AbstractToolSession
    implements AxisRotateToolSession {
        private final Location originalLocation;
        private final Vector3fc originalTranslation;
        private final Quaternionfc originalRotation;
        private final Vector3dc originalOffset;
        private final Vector3dc translationOffset;
        private final Vector3dc direction;
        private final Vector3dc localDirection;
        private final Quaternionf currentRotation;
        private final Vector3f currentTranslation;
        private final Vector3d offsetChange;
        private double change;

        public SessionImpl() {
            super(DisplayAxisRotateTool.this.properties);
            this.currentRotation = new Quaternionf();
            this.currentTranslation = new Vector3f();
            this.offsetChange = new Vector3d();
            float height = ((Float)DisplayAxisRotateTool.this.heightProperty.getValue()).floatValue();
            Quaterniondc rotation = DisplayAxisRotateTool.this.getRotation();
            Quaterniond localRotation = DisplayAxisRotateTool.this.parentRotationProvider.getRotation().conjugate(new Quaterniond()).mul(rotation);
            this.originalLocation = ((Location)DisplayAxisRotateTool.this.locationProperty.getValue()).clone();
            this.originalTranslation = new Vector3f((Vector3fc)DisplayAxisRotateTool.this.translationProperty.getValue());
            this.originalRotation = new Quaternionf((Quaternionfc)DisplayAxisRotateTool.this.rotationProperty.getValue());
            this.originalOffset = Util.toVector3d(this.originalLocation).add(0.0, height / 2.0f, 0.0).sub(DisplayAxisRotateTool.this.getPosition());
            this.translationOffset = new Vector3d(this.originalTranslation).sub(0.0, height / 2.0f, 0.0);
            this.direction = DisplayAxisRotateTool.this.axis.getDirection().rotate(rotation, new Vector3d());
            this.localDirection = DisplayAxisRotateTool.this.axis.getDirection().rotate(localRotation, new Vector3d());
        }

        @Override
        public void setChange(double change) {
            PendingChange rotationChange;
            PendingChange translationChange;
            this.change = change;
            this.originalOffset.rotateAxis(change, this.direction.x(), this.direction.y(), this.direction.z(), this.offsetChange).sub(this.originalOffset);
            Location location = this.originalLocation.clone();
            location.add(this.offsetChange.x(), this.offsetChange.y(), this.offsetChange.z());
            this.translationOffset.rotateAxis(change, this.direction.x(), this.direction.y(), this.direction.z(), this.offsetChange).sub(this.translationOffset);
            this.originalTranslation.add(this.offsetChange.get(new Vector3f()), this.currentTranslation);
            this.currentRotation.setAngleAxis(change, this.localDirection.x(), this.localDirection.y(), this.localDirection.z()).mul(this.originalRotation);
            PendingChange locationChange = DisplayAxisRotateTool.this.locationProperty.prepareChange(location);
            if (locationChange != null && (translationChange = DisplayAxisRotateTool.this.translationProperty.prepareChange(this.currentTranslation)) != null && (rotationChange = DisplayAxisRotateTool.this.rotationProperty.prepareChange(this.currentRotation)) != null && locationChange.execute() && translationChange.execute()) {
                rotationChange.execute();
            }
        }

        @Override
        public double snapChange(double change, @NotNull Snapper context) {
            return context.snapAngle(change);
        }

        @Override
        public void revert() {
            DisplayAxisRotateTool.this.locationProperty.setValue(this.originalLocation);
            DisplayAxisRotateTool.this.translationProperty.setValue(this.originalTranslation);
            DisplayAxisRotateTool.this.rotationProperty.setValue(this.originalRotation);
        }

        @Override
        @Nullable
        public Component getStatus() {
            return Util.formatAngle(this.change);
        }

        @Override
        @Nullable
        public Component getDescription() {
            TextComponent axisName = Component.text(DisplayAxisRotateTool.this.axis.getName(), TextColor.color(DisplayAxisRotateTool.this.axis.getColor()));
            return Message.component("easyarmorstands.history.rotate-axis", axisName);
        }
    }
}

