/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.menu;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import me.m56738.easyarmorstands.EasyArmorStandsPlugin;
import me.m56738.easyarmorstands.api.menu.Menu;
import me.m56738.easyarmorstands.api.menu.MenuClick;
import me.m56738.easyarmorstands.api.menu.MenuClickInterceptor;
import me.m56738.easyarmorstands.api.menu.MenuCloseListener;
import me.m56738.easyarmorstands.api.menu.MenuSlot;
import me.m56738.easyarmorstands.capability.component.ComponentCapability;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.lib.kyori.adventure.translation.GlobalTranslator;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MenuImpl
implements InventoryHolder,
Menu {
    private final Inventory inventory;
    private final MenuSlot[] slots;
    private final Locale locale;
    private final List<MenuCloseListener> closeListeners = new ArrayList<MenuCloseListener>();
    private MenuClickInterceptor currentInterceptor;

    public MenuImpl(Component title, MenuSlot[] slots, Locale locale) {
        ComponentCapability capability = EasyArmorStandsPlugin.getInstance().getCapability(ComponentCapability.class);
        this.locale = locale;
        this.inventory = capability.createInventory(this, slots.length, GlobalTranslator.render(title, locale));
        this.slots = slots;
        this.updateItems();
    }

    @Override
    public MenuSlot getSlot(int index) {
        if (index < 0 || index >= this.slots.length) {
            return null;
        }
        return this.slots[index];
    }

    @Override
    public int getSize() {
        return this.slots.length;
    }

    @Override
    public void onClick(@NotNull MenuClick click) {
        MenuSlot slot = click.slot();
        if (slot == null) {
            return;
        }
        MenuClickInterceptor interceptor = this.currentInterceptor;
        if (interceptor != null) {
            this.currentInterceptor = null;
            interceptor.interceptClick(click);
            return;
        }
        slot.onClick(click);
    }

    public void updateItems() {
        for (int i = 0; i < this.slots.length; ++i) {
            this.updateItem(i);
        }
    }

    @Override
    public void updateItems(@NotNull @NotNull Predicate<@NotNull MenuSlot> predicate) {
        for (int i = 0; i < this.slots.length; ++i) {
            MenuSlot slot = this.slots[i];
            if (slot == null || !predicate.test(slot)) continue;
            this.inventory.setItem(i, slot.getItem(this.locale));
        }
    }

    @Override
    @Nullable
    public ItemStack getItem(int index) {
        MenuSlot slot = this.slots[index];
        if (slot != null) {
            return slot.getItem(this.locale);
        }
        return null;
    }

    @Override
    public void updateItem(int index) {
        MenuSlot slot = this.slots[index];
        if (slot != null) {
            this.inventory.setItem(index, slot.getItem(this.locale));
        }
    }

    @Override
    public void updateItem(@NotNull MenuSlot slot) {
        ItemStack item = slot.getItem(this.locale);
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] != slot) continue;
            this.inventory.setItem(i, item);
        }
    }

    @Override
    public void queueTask(@NotNull Runnable task) {
        EasyArmorStandsPlugin plugin = EasyArmorStandsPlugin.getInstance();
        plugin.getServer().getScheduler().runTask((Plugin)plugin, task);
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    @Override
    public void interceptNextClick(@NotNull MenuClickInterceptor interceptor) {
        this.currentInterceptor = interceptor;
    }

    @Override
    public void addCloseListener(@NotNull MenuCloseListener listener) {
        this.closeListeners.add(listener);
    }

    @Override
    public void close(@NotNull Player player) {
        for (MenuCloseListener listener : this.closeListeners) {
            listener.onClose(player, this);
        }
        if (this.inventory.equals((Object)player.getOpenInventory().getTopInventory())) {
            player.closeInventory();
        }
    }
}

