/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.lib.gizmo.cube;

import me.m56738.easyarmorstands.lib.gizmo.AbstractPointGizmo;
import me.m56738.easyarmorstands.lib.gizmo.cube.CubeGizmo;
import me.m56738.easyarmorstands.lib.joml.Quaterniondc;
import me.m56738.easyarmorstands.lib.joml.Vector3d;
import me.m56738.easyarmorstands.lib.joml.Vector3dc;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
class CubePointGizmo
extends AbstractPointGizmo {
    private final CubeGizmo cube;

    public CubePointGizmo(CubeGizmo cube) {
        this.cube = cube;
    }

    @Override
    public void show() {
        this.updateCube();
        this.cube.show();
    }

    @Override
    public void update() {
        this.updateCube();
        this.cube.update();
    }

    @Override
    public void hide() {
        this.cube.hide();
    }

    private void updateCube() {
        if (!this.checkAndClearDirty()) {
            return;
        }
        double size = this.getSize();
        Vector3dc offset = this.getOffset();
        Quaterniondc rotation = this.getRotation();
        Vector3d translation = new Vector3d(-size / 2.0);
        translation.rotate(rotation);
        translation.add(offset);
        this.cube.setPosition(this.getPosition());
        this.cube.setOffset(translation);
        this.cube.setRotation(rotation);
        this.cube.setScale(new Vector3d(size));
        this.cube.setColor(this.getColor());
        this.cube.setBillboard(this.isBillboard());
    }
}

