/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.lib.cloud.bukkit;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import me.m56738.easyarmorstands.lib.cloud.CloudCapability;
import me.m56738.easyarmorstands.lib.cloud.bukkit.internal.CraftBukkitReflection;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

public enum CloudBukkitCapabilities implements CloudCapability
{
    BRIGADIER(CraftBukkitReflection.classExists("com.mojang.brigadier.tree.CommandNode") && (CraftBukkitReflection.findOBCClass("command.BukkitCommandWrapper") != null || CraftBukkitReflection.classExists("io.papermc.paper.command.brigadier.CommandSourceStack"))),
    NATIVE_BRIGADIER(CraftBukkitReflection.classExists("com.destroystokyo.paper.event.brigadier.CommandRegisteredEvent") || CraftBukkitReflection.classExists("io.papermc.paper.command.brigadier.CommandSourceStack")),
    COMMODORE_BRIGADIER(BRIGADIER.capable() && !NATIVE_BRIGADIER.capable() && !CraftBukkitReflection.classExists("org.bukkit.entity.Warden")),
    ASYNCHRONOUS_COMPLETION(CraftBukkitReflection.classExists("com.destroystokyo.paper.event.server.AsyncTabCompleteEvent"));

    @API(status=API.Status.INTERNAL)
    public static final Set<CloudBukkitCapabilities> CAPABLE;
    private final boolean capable;

    private CloudBukkitCapabilities(boolean capable) {
        this.capable = capable;
    }

    boolean capable() {
        return this.capable;
    }

    @Override
    public @NonNull String toString() {
        return this.name();
    }

    static {
        CAPABLE = Arrays.stream(CloudBukkitCapabilities.values()).filter(CloudBukkitCapabilities::capable).collect(Collectors.toSet());
    }
}

