/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.capability.mannequin.v1_21_10_spigot;

import java.util.Objects;
import java.util.UUID;
import me.m56738.easyarmorstands.api.profile.Profile;
import me.m56738.easyarmorstands.capability.mannequin.v1_21_10_spigot.TextureAdapter;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.object.ObjectContents;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.object.PlayerHeadObjectContents;
import org.bukkit.profile.PlayerProfile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerProfileWrapper
implements Profile {
    private final PlayerProfile profile;

    public PlayerProfileWrapper(PlayerProfile profile) {
        this.profile = profile;
    }

    public PlayerProfile getProfile() {
        return this.profile;
    }

    @Override
    @Nullable
    public String getName() {
        return this.profile.getName();
    }

    @Override
    @Nullable
    public UUID getUniqueId() {
        return this.profile.getUniqueId();
    }

    @Override
    @NotNull
    public Component asComponent() {
        String value = null;
        try {
            value = TextureAdapter.getValue(this.profile.getTextures());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (value != null) {
            PlayerHeadObjectContents.Builder builder = ObjectContents.playerHead();
            builder.name(this.profile.getName());
            builder.id(this.profile.getUniqueId());
            builder.profileProperty(PlayerHeadObjectContents.property("textures", value));
            return Component.object(builder.build());
        }
        String name = this.getName();
        if (name != null) {
            return Component.text(name);
        }
        UUID id = this.getUniqueId();
        if (id != null) {
            return Component.text(id.toString());
        }
        return Component.empty();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlayerProfileWrapper that = (PlayerProfileWrapper)o;
        return Objects.equals(this.profile, that.profile);
    }

    public int hashCode() {
        return Objects.hashCode(this.profile);
    }
}

