/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.addon;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.m56738.easyarmorstands.addon.Addon;
import me.m56738.easyarmorstands.addon.AddonFactory;

public class AddonManager {
    private final List<Addon> addons = new ArrayList<Addon>();
    private final Logger logger;

    public AddonManager(Logger logger) {
        this.logger = logger;
    }

    public void load(ClassLoader loader) {
        ArrayList<AddonFactory> addonFactories = new ArrayList<AddonFactory>();
        for (AddonFactory addonFactory : ServiceLoader.load(AddonFactory.class, loader)) {
            addonFactories.add(addonFactory);
        }
        addonFactories.sort(Comparator.comparing(AddonFactory::getPriority));
        for (AddonFactory<Object> addonFactory : addonFactories) {
            this.load(addonFactory);
        }
    }

    public <T extends Addon> void load(AddonFactory<T> addonFactory) {
        T addon;
        try {
            if (!addonFactory.isEnabled()) {
                return;
            }
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, "Failed to check if addon is enabled: " + addonFactory.getClass().getName(), e);
            return;
        }
        try {
            if (!addonFactory.isAvailable()) {
                return;
            }
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, "Failed to check if addon is available: " + addonFactory.getClass().getName(), e);
            return;
        }
        try {
            addon = addonFactory.create();
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, "Failed to initialize addon: " + addonFactory.getClass().getName(), e);
            return;
        }
        this.addons.add((Addon)addon);
    }

    public void enable() {
        for (Addon addon : this.addons) {
            String name = addon.name();
            if (name != null) {
                this.logger.info("Enabling " + name + " integration");
            }
            try {
                addon.enable();
            }
            catch (Throwable e) {
                this.logger.log(Level.SEVERE, "Failed to enable addon: " + addon.getClass().getName(), e);
                return;
            }
        }
    }

    public void disable() {
        for (int i = this.addons.size() - 1; i >= 0; --i) {
            Addon addon = this.addons.get(i);
            try {
                addon.disable();
                continue;
            }
            catch (Throwable e) {
                this.logger.log(Level.SEVERE, "Failed to disable addon: " + addon.getClass().getName(), e);
                return;
            }
        }
        this.addons.clear();
    }

    public void reload() {
        for (Addon addon : this.addons) {
            try {
                addon.reload();
            }
            catch (Throwable e) {
                this.logger.log(Level.SEVERE, "Failed to reload addon: " + addon.getClass().getName(), e);
                return;
            }
        }
    }

    public Collection<Addon> getAddons() {
        return Collections.unmodifiableCollection(this.addons);
    }
}

