/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.adapter;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import me.m56738.easyarmorstands.session.SessionListener;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventException;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;

public class EntityPlaceAdapter {
    public static void enable(Plugin plugin, SessionListener listener) throws ReflectiveOperationException {
        Class<?> eventClass = Class.forName("org.bukkit.event.entity.EntityPlaceEvent");
        MethodHandle playerGetter = MethodHandles.lookup().findVirtual(eventClass, "getPlayer", MethodType.methodType(Player.class));
        MethodHandle entityGetter = MethodHandles.lookup().findVirtual(eventClass, "getEntity", MethodType.methodType(Entity.class));
        plugin.getServer().getPluginManager().registerEvent(eventClass, (Listener)listener, EventPriority.NORMAL, (EventExecutor)new Executor(listener, playerGetter, entityGetter), plugin);
    }

    private static class Executor
    implements EventExecutor {
        private final SessionListener sessionListener;
        private final MethodHandle playerGetter;
        private final MethodHandle entityGetter;

        private Executor(SessionListener sessionListener, MethodHandle playerGetter, MethodHandle entityGetter) {
            this.sessionListener = sessionListener;
            this.playerGetter = playerGetter;
            this.entityGetter = entityGetter;
        }

        public void execute(Listener listener, Event event) throws EventException {
            Entity entity;
            Player player;
            try {
                player = this.playerGetter.invoke(event);
                entity = this.entityGetter.invoke(event);
            }
            catch (Throwable e) {
                throw new EventException(e);
            }
            this.sessionListener.onPlaceEntity(player, entity);
        }
    }
}

