/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.session;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import me.m56738.easyarmorstands.api.editor.Session;
import me.m56738.easyarmorstands.api.editor.SessionManager;
import me.m56738.easyarmorstands.api.editor.node.Node;
import me.m56738.easyarmorstands.api.event.session.SessionStartEvent;
import me.m56738.easyarmorstands.api.event.session.SessionStopEvent;
import me.m56738.easyarmorstands.command.sender.EasPlayer;
import me.m56738.easyarmorstands.editor.armorstand.node.ArmorStandRootNode;
import me.m56738.easyarmorstands.editor.node.ElementSelectionNodeImpl;
import me.m56738.easyarmorstands.editor.node.EntityElementDiscoverySource;
import me.m56738.easyarmorstands.session.SessionImpl;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SessionManagerImpl
implements SessionManager {
    private final HashMap<Player, SessionImpl> sessions = new HashMap();

    public void startSession(SessionImpl session) {
        SessionImpl old = this.sessions.put(session.player(), session);
        if (old != null) {
            old.stop();
            Bukkit.getPluginManager().callEvent((Event)new SessionStopEvent(old));
        }
        Bukkit.getPluginManager().callEvent((Event)new SessionStartEvent(session));
    }

    @Override
    @NotNull
    public SessionImpl startSession(@NotNull Player player) {
        SessionImpl session = new SessionImpl(new EasPlayer(player));
        ElementSelectionNodeImpl node = new ElementSelectionNodeImpl(session);
        node.addSource(new EntityElementDiscoverySource(player));
        session.pushNode(node);
        this.startSession(session);
        return session;
    }

    @Override
    public void stopSession(@NotNull Session session) {
        SessionImpl s = (SessionImpl)session;
        if (this.sessions.remove(session.player(), s)) {
            s.stop();
            Bukkit.getPluginManager().callEvent((Event)new SessionStopEvent(session));
        }
    }

    public boolean stopSession(Player player) {
        SessionImpl session = this.sessions.remove(player);
        if (session != null) {
            session.stop();
            Bukkit.getPluginManager().callEvent((Event)new SessionStopEvent(session));
            return true;
        }
        return false;
    }

    public void update() {
        Iterator<SessionImpl> iterator = this.sessions.values().iterator();
        while (iterator.hasNext()) {
            SessionImpl session = iterator.next();
            boolean valid = session.update();
            if (valid) continue;
            iterator.remove();
            session.stop();
            Bukkit.getPluginManager().callEvent((Event)new SessionStopEvent(session));
        }
    }

    public void hideSkeletons(Player player) {
        for (SessionImpl session : this.sessions.values()) {
            for (Node node : session.getNodeStack()) {
                if (!(node instanceof ArmorStandRootNode)) continue;
                ((ArmorStandRootNode)node).hideSkeleton(player);
            }
        }
    }

    public void stopAllSessions() {
        ArrayList<SessionImpl> sessions = new ArrayList<SessionImpl>(this.sessions.values());
        this.sessions.clear();
        for (SessionImpl session : sessions) {
            session.stop();
        }
        for (SessionImpl session : sessions) {
            Bukkit.getPluginManager().callEvent((Event)new SessionStopEvent(session));
        }
    }

    public Collection<SessionImpl> getAllSessions() {
        return Collections.unmodifiableCollection(this.sessions.values());
    }

    @Override
    @Nullable
    public SessionImpl getSession(@NotNull Player player) {
        return this.sessions.get(player);
    }
}

