/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.property.entity;

import java.util.HashSet;
import java.util.Set;
import me.m56738.easyarmorstands.api.property.Property;
import me.m56738.easyarmorstands.api.property.type.EntityPropertyTypes;
import me.m56738.easyarmorstands.api.property.type.PropertyType;
import me.m56738.easyarmorstands.capability.entitytag.EntityTagCapability;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class EntityTagsProperty
implements Property<Set<String>> {
    private final Entity entity;
    private final EntityTagCapability tagCapability;

    public EntityTagsProperty(Entity entity, EntityTagCapability tagCapability) {
        this.entity = entity;
        this.tagCapability = tagCapability;
    }

    @Override
    @NotNull
    public PropertyType<Set<String>> getType() {
        return EntityPropertyTypes.TAGS;
    }

    @Override
    @NotNull
    public Set<String> getValue() {
        return this.tagCapability.getTags(this.entity);
    }

    @Override
    public boolean setValue(@NotNull Set<String> value) {
        HashSet<String> currentTags = new HashSet<String>(this.tagCapability.getTags(this.entity));
        boolean changed = false;
        for (String tag : currentTags) {
            if (value.contains(tag) || !this.tagCapability.removeTag(this.entity, tag)) continue;
            changed = true;
        }
        for (String tag : value) {
            if (currentTags.contains(tag) || !this.tagCapability.addTag(this.entity, tag)) continue;
            changed = true;
        }
        return changed;
    }
}

