/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.plotsquared.v6;

import com.plotsquared.bukkit.util.BukkitUtil;
import com.plotsquared.core.PlotAPI;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import me.m56738.easyarmorstands.EasyArmorStandsPlugin;
import me.m56738.easyarmorstands.api.element.Element;
import me.m56738.easyarmorstands.api.property.PropertyContainer;
import me.m56738.easyarmorstands.api.region.RegionPrivilegeChecker;
import me.m56738.easyarmorstands.message.Message;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PlotSquaredPrivilegeChecker
implements RegionPrivilegeChecker {
    private final PlotAPI api;

    public PlotSquaredPrivilegeChecker(PlotAPI api) {
        this.api = api;
    }

    @Override
    public boolean isAllowed(Player player, org.bukkit.Location location) {
        Location plotLocation = BukkitUtil.adapt((org.bukkit.Location)location);
        PlotArea area = this.api.getPlotSquared().getPlotAreaManager().getPlotArea(plotLocation);
        if (area == null) {
            return true;
        }
        Plot plot = area.getPlot(plotLocation);
        if (plot == null) {
            return false;
        }
        return plot.isAdded(BukkitUtil.adapt((Player)player).getUUID());
    }

    @Override
    public boolean canBypass(Player player) {
        return player.hasPermission("easyarmorstands.plotsquared.bypass");
    }

    @Override
    public void sendCreateError(@NotNull Player player, @NotNull PropertyContainer properties) {
        EasyArmorStandsPlugin.getInstance().getAdventure().player(player).sendMessage(Message.error("easyarmorstands.error.plotsquared.deny-create"));
    }

    @Override
    public void sendDestroyError(@NotNull Player player, @NotNull Element element) {
        EasyArmorStandsPlugin.getInstance().getAdventure().player(player).sendMessage(Message.error("easyarmorstands.error.plotsquared.deny-destroy"));
    }

    @Override
    public void sendEditError(@NotNull Player player, @NotNull Element element) {
        EasyArmorStandsPlugin.getInstance().getAdventure().player(player).sendMessage(Message.error("easyarmorstands.error.plotsquared.deny-select"));
    }
}

