/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.lib.gizmo.api.cursor;

import me.m56738.easyarmorstands.lib.gizmo.api.cursor.Cursor;
import me.m56738.easyarmorstands.lib.gizmo.api.cursor.Intersection;
import me.m56738.easyarmorstands.lib.gizmo.intersection.SimpleIntersection;
import me.m56738.easyarmorstands.lib.joml.Intersectiond;
import me.m56738.easyarmorstands.lib.joml.Quaterniond;
import me.m56738.easyarmorstands.lib.joml.Quaterniondc;
import me.m56738.easyarmorstands.lib.joml.Vector2d;
import me.m56738.easyarmorstands.lib.joml.Vector3d;
import me.m56738.easyarmorstands.lib.joml.Vector3dc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RayCursor
implements Cursor {
    private final Vector3dc origin;
    private final Vector3dc direction;
    private final Vector3dc end;
    private final double length;

    RayCursor(@NotNull Vector3dc origin, @NotNull Vector3dc direction, double length) {
        this.origin = new Vector3d(origin);
        this.direction = new Vector3d(direction).normalize();
        this.end = new Vector3d(this.origin).fma(length, this.direction);
        this.length = length;
    }

    RayCursor(@NotNull Vector3dc origin, @NotNull Vector3dc end) {
        this.origin = new Vector3d(origin);
        this.end = new Vector3d(end);
        this.direction = new Vector3d(this.end).sub(this.origin).normalize();
        this.length = this.origin.distance(this.end);
    }

    @Override
    @Nullable
    public Intersection intersectPoint(@NotNull Vector3dc position, double threshold) {
        Vector3d cursorPoint = new Vector3d();
        Intersectiond.findClosestPointOnLineSegment(this.origin.x(), this.origin.y(), this.origin.z(), this.end.x(), this.end.y(), this.end.z(), position.x(), position.y(), position.z(), cursorPoint);
        double distanceSquared = cursorPoint.distanceSquared(position);
        if (distanceSquared <= threshold * threshold) {
            return new SimpleIntersection(cursorPoint, new Vector3d(position));
        }
        return null;
    }

    @Override
    @Nullable
    public Intersection intersectLine(@NotNull Vector3dc start, @NotNull Vector3dc end, double threshold) {
        Vector3d cursorPoint = new Vector3d();
        Vector3d linePoint = new Vector3d();
        double distanceSquared = Intersectiond.findClosestPointsLineSegments(this.origin.x(), this.origin.y(), this.origin.z(), this.end.x(), this.end.y(), this.end.z(), start.x(), start.y(), start.z(), end.x(), end.y(), end.z(), cursorPoint, linePoint);
        if (distanceSquared <= threshold * threshold) {
            return new SimpleIntersection(cursorPoint, linePoint);
        }
        return null;
    }

    @Override
    @Nullable
    public Intersection intersectPlane(@NotNull Vector3dc point, @NotNull Vector3dc normal) {
        return this.intersectPlane(point, normal, this.length);
    }

    @Override
    @Nullable
    public Intersection intersectPlane(@NotNull Vector3dc point, @NotNull Vector3dc normal, double range) {
        double t = Intersectiond.intersectRayPlane(this.origin, this.direction, point, normal, 0.1);
        if (t < 0.0) {
            t = Intersectiond.intersectRayPlane(this.origin, this.direction, point, normal.negate(new Vector3d()), 0.1);
        }
        if (t >= 0.0 && t <= range) {
            return new SimpleIntersection(this.origin.fma(t, this.direction, new Vector3d()));
        }
        return null;
    }

    @Override
    @Nullable
    public Intersection intersectBox(@NotNull Vector3dc min, @NotNull Vector3dc max) {
        Vector2d result = new Vector2d();
        int status = Intersectiond.intersectLineSegmentAab(this.origin, this.end, min, max, result);
        if (status != -1) {
            return new SimpleIntersection(this.origin.fma(result.x, this.direction, new Vector3d()));
        }
        return null;
    }

    @Override
    @Nullable
    public Intersection intersectBox(@NotNull Vector3dc min, @NotNull Vector3dc max, @NotNull Vector3dc center, @NotNull Quaterniondc rotation) {
        Vector2d result;
        Vector3d relativeEnd;
        if (rotation.equals(0.0, 0.0, 0.0, 1.0)) {
            return this.intersectBox(min, max);
        }
        Quaterniond inverseRotation = rotation.conjugate(new Quaterniond());
        Vector3d relativeOrigin = this.origin.sub(center, new Vector3d()).rotate(inverseRotation).add(center);
        int status = Intersectiond.intersectLineSegmentAab(relativeOrigin, relativeEnd = this.end.sub(center, new Vector3d()).rotate(inverseRotation).add(center), min, max, result = new Vector2d());
        if (status != -1) {
            return new SimpleIntersection(this.origin.fma(result.x, this.direction, new Vector3d()));
        }
        return null;
    }

    @Override
    @Nullable
    public Intersection intersectCircle(@NotNull Vector3dc center, @NotNull Vector3dc axis, double radius, double threshold) {
        Intersection intersection = this.intersectPlane(center, axis);
        if (intersection == null) {
            return null;
        }
        Vector3dc planePosition = intersection.positionOnTarget();
        double distance = planePosition.distance(center);
        double circleDistance = Math.abs(distance - radius);
        if (circleDistance <= threshold) {
            Vector3d circlePosition = center.lerp(planePosition, radius / distance, new Vector3d());
            return new SimpleIntersection(planePosition, circlePosition);
        }
        return null;
    }
}

