/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.lib.configurate.serialize;

import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.Predicate;
import me.m56738.easyarmorstands.lib.configurate.serialize.CoercionFailedException;
import me.m56738.easyarmorstands.lib.configurate.serialize.ScalarSerializer;
import me.m56738.easyarmorstands.lib.configurate.serialize.SerializationException;

final class UriSerializer
extends ScalarSerializer<URI> {
    UriSerializer() {
        super(URI.class);
    }

    @Override
    public URI deserialize(Type type, Object obj) throws SerializationException {
        String plainUri = obj.toString();
        try {
            return new URI(plainUri);
        }
        catch (URISyntaxException e) {
            throw new CoercionFailedException(obj, "URI");
        }
    }

    @Override
    public Object serialize(URI item, Predicate<Class<?>> typeSupported) {
        return item.toString();
    }
}

