/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.lib.configurate;

import java.util.Map;
import java.util.stream.Collector;
import me.m56738.easyarmorstands.lib.configurate.ConfigurationNode;
import me.m56738.easyarmorstands.lib.configurate.ConfigurationOptions;
import me.m56738.easyarmorstands.lib.configurate.serialize.SerializationException;
import me.m56738.easyarmorstands.lib.configurate.util.CheckedConsumer;
import me.m56738.easyarmorstands.lib.geantyref.TypeToken;

@FunctionalInterface
public interface ConfigurationNodeFactory<N extends ConfigurationNode> {
    default public ConfigurationOptions defaultOptions() {
        return ConfigurationOptions.defaults();
    }

    public N createNode(ConfigurationOptions var1);

    default public N createNode() {
        return this.createNode(this.defaultOptions());
    }

    default public <E extends Exception> N createNode(CheckedConsumer<N, E> action) throws E {
        N node = this.createNode();
        action.accept(node);
        return node;
    }

    default public <E extends Exception> N createNode(ConfigurationOptions options, CheckedConsumer<N, E> action) throws E {
        N node = this.createNode(options);
        action.accept(node);
        return node;
    }

    default public <V> Collector<Map.Entry<?, V>, N, N> toMapCollector(TypeToken<V> valueType) {
        return Collector.of(this::createNode, (node, entry) -> {
            try {
                node.node(entry.getKey()).set(valueType, entry.getValue());
            }
            catch (SerializationException e) {
                throw new IllegalArgumentException(e);
            }
        }, (a, b) -> {
            a.mergeFrom((ConfigurationNode)b);
            return a;
        }, new Collector.Characteristics[0]);
    }

    default public <V> Collector<Map.Entry<?, V>, N, N> toMapCollector(Class<V> valueType) {
        return Collector.of(this::createNode, (node, entry) -> {
            try {
                node.node(entry.getKey()).set(valueType, entry.getValue());
            }
            catch (SerializationException e) {
                throw new IllegalArgumentException(e);
            }
        }, (a, b) -> {
            a.mergeFrom((ConfigurationNode)b);
            return a;
        }, new Collector.Characteristics[0]);
    }

    default public <V> Collector<V, N, N> toListCollector(TypeToken<V> valueType) {
        return Collector.of(this::createNode, (node, value) -> {
            try {
                node.appendListNode().set(valueType, value);
            }
            catch (SerializationException e) {
                throw new IllegalArgumentException(e);
            }
        }, (a, b) -> {
            a.mergeFrom((ConfigurationNode)b);
            return a;
        }, new Collector.Characteristics[0]);
    }

    default public <V> Collector<V, N, N> toListCollector(Class<V> valueType) {
        return Collector.of(this::createNode, (node, value) -> {
            try {
                node.appendListNode().set(valueType, value);
            }
            catch (SerializationException e) {
                throw new IllegalArgumentException(e);
            }
        }, (a, b) -> {
            a.mergeFrom((ConfigurationNode)b);
            return a;
        }, new Collector.Characteristics[0]);
    }
}

