/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.lib.cloud.paper;

import java.util.function.Function;
import me.m56738.easyarmorstands.lib.cloud.SenderMapper;
import me.m56738.easyarmorstands.lib.cloud.brigadier.BrigadierManagerHolder;
import me.m56738.easyarmorstands.lib.cloud.brigadier.BrigadierSetting;
import me.m56738.easyarmorstands.lib.cloud.brigadier.CloudBrigadierManager;
import me.m56738.easyarmorstands.lib.cloud.bukkit.BukkitCommandManager;
import me.m56738.easyarmorstands.lib.cloud.bukkit.CloudBukkitCapabilities;
import me.m56738.easyarmorstands.lib.cloud.bukkit.internal.CraftBukkitReflection;
import me.m56738.easyarmorstands.lib.cloud.execution.ExecutionCoordinator;
import me.m56738.easyarmorstands.lib.cloud.paper.LegacyPaperBrigadier;
import me.m56738.easyarmorstands.lib.cloud.paper.ModernPaperBrigadier;
import me.m56738.easyarmorstands.lib.cloud.paper.PaperCommandPreprocessor;
import me.m56738.easyarmorstands.lib.cloud.paper.suggestion.SuggestionListener;
import me.m56738.easyarmorstands.lib.cloud.paper.suggestion.SuggestionListenerFactory;
import me.m56738.easyarmorstands.lib.cloud.state.RegistrationState;
import org.apiguardian.api.API;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class LegacyPaperCommandManager<C>
extends BukkitCommandManager<C> {
    private @Nullable BrigadierManagerHolder<C, ?> brigadierManagerHolder = null;

    @API(status=API.Status.STABLE, since="2.0.0")
    public LegacyPaperCommandManager(@NonNull Plugin owningPlugin, @NonNull ExecutionCoordinator<C> commandExecutionCoordinator, @NonNull SenderMapper<CommandSender, C> senderMapper) throws BukkitCommandManager.InitializationException {
        super(owningPlugin, commandExecutionCoordinator, senderMapper);
        this.registerCommandPreProcessor(new PaperCommandPreprocessor(this, this.senderMapper(), Function.identity()));
    }

    @API(status=API.Status.STABLE, since="2.0.0")
    public static @NonNull LegacyPaperCommandManager<@NonNull CommandSender> createNative(@NonNull Plugin owningPlugin, @NonNull ExecutionCoordinator<CommandSender> commandExecutionCoordinator) throws BukkitCommandManager.InitializationException {
        return new LegacyPaperCommandManager<CommandSender>(owningPlugin, commandExecutionCoordinator, SenderMapper.identity());
    }

    @Override
    public synchronized void registerBrigadier() throws BukkitCommandManager.BrigadierInitializationException {
        this.registerBrigadier(true);
    }

    @Deprecated
    public synchronized void registerLegacyPaperBrigadier() throws BukkitCommandManager.BrigadierInitializationException {
        this.registerBrigadier(false);
    }

    private void registerBrigadier(boolean allowModern) {
        this.requireState(RegistrationState.BEFORE_REGISTRATION);
        this.checkBrigadierCompatibility();
        if (this.brigadierManagerHolder != null) {
            throw new IllegalStateException("Brigadier is already registered! Holder: " + this.brigadierManagerHolder);
        }
        if (!this.hasCapability(CloudBukkitCapabilities.NATIVE_BRIGADIER)) {
            super.registerBrigadier();
        } else {
            if (allowModern && CraftBukkitReflection.classExists("io.papermc.paper.command.brigadier.CommandSourceStack")) {
                try {
                    ModernPaperBrigadier brig = new ModernPaperBrigadier(CommandSender.class, this, this.senderMapper(), () -> this.lockRegistration());
                    this.brigadierManagerHolder = brig;
                    brig.registerPlugin(this.owningPlugin());
                    this.commandRegistrationHandler(brig);
                }
                catch (Exception e) {
                    throw new BukkitCommandManager.BrigadierInitializationException("Failed to register ModernPaperBrigadier", e);
                }
            }
            try {
                this.brigadierManagerHolder = new LegacyPaperBrigadier(this);
                Bukkit.getPluginManager().registerEvents((Listener)this.brigadierManagerHolder, this.owningPlugin());
                this.brigadierManagerHolder.brigadierManager().settings().set(BrigadierSetting.FORCE_EXECUTABLE, true);
            }
            catch (Exception e) {
                throw new BukkitCommandManager.BrigadierInitializationException("Failed to register LegacyPaperBrigadier", e);
            }
        }
    }

    @Override
    @API(status=API.Status.STABLE, since="2.0.0")
    public boolean hasBrigadierManager() {
        return this.brigadierManagerHolder != null || super.hasBrigadierManager();
    }

    @Override
    @API(status=API.Status.STABLE, since="2.0.0")
    public @NonNull CloudBrigadierManager<C, ?> brigadierManager() {
        if (this.brigadierManagerHolder != null) {
            return this.brigadierManagerHolder.brigadierManager();
        }
        return super.brigadierManager();
    }

    public void registerAsynchronousCompletions() throws IllegalStateException {
        this.requireState(RegistrationState.BEFORE_REGISTRATION);
        if (!this.hasCapability(CloudBukkitCapabilities.ASYNCHRONOUS_COMPLETION)) {
            throw new IllegalStateException("Failed to register asynchronous command completion listener.");
        }
        SuggestionListenerFactory suggestionListenerFactory = SuggestionListenerFactory.create(this);
        SuggestionListener suggestionListener = suggestionListenerFactory.createListener();
        Bukkit.getServer().getPluginManager().registerEvents(suggestionListener, this.owningPlugin());
    }
}

