/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.huskclaims;

import java.lang.reflect.Method;
import me.m56738.easyarmorstands.EasyArmorStandsPlugin;
import me.m56738.easyarmorstands.addon.Addon;
import me.m56738.easyarmorstands.api.EasyArmorStands;
import me.m56738.easyarmorstands.huskclaims.HuskClaimsPrivilegeChecker;
import net.william278.huskclaims.api.BukkitHuskClaimsAPI;
import net.william278.huskclaims.libraries.cloplib.operation.OperationType;
import net.william278.huskclaims.libraries.cloplib.operation.OperationTypeRegistry;
import org.bukkit.plugin.Plugin;

public class HuskClaimsAddon
implements Addon {
    private Class<?> keyClass;
    private Object operationTypeKey;
    private OperationTypeRegistry operationTypeRegistry;
    private OperationType operationType;
    private HuskClaimsPrivilegeChecker privilegeChecker;

    @Override
    public String name() {
        return "HuskClaims";
    }

    @Override
    public void enable() {
        BukkitHuskClaimsAPI api = BukkitHuskClaimsAPI.getInstance();
        this.operationTypeRegistry = api.getOperationTypeRegistry();
        try {
            this.registerOperationType();
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        this.privilegeChecker = new HuskClaimsPrivilegeChecker(api, this.operationType);
        EasyArmorStands.get().regionPrivilegeManager().registerPrivilegeChecker((Plugin)EasyArmorStandsPlugin.getInstance(), this.privilegeChecker);
    }

    @Override
    public void disable() {
        if (this.privilegeChecker != null) {
            EasyArmorStands.get().regionPrivilegeManager().unregisterPrivilegeChecker(this.privilegeChecker);
            this.privilegeChecker = null;
        }
        if (this.operationType != null) {
            try {
                this.unregisterOperationType();
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
            this.operationType = null;
        }
    }

    private void registerOperationType() throws ReflectiveOperationException {
        String adventure = String.join((CharSequence)".", "net", "kyori", "adventure");
        this.keyClass = Class.forName(adventure + ".key.Key");
        Method keyMethod = this.keyClass.getMethod("key", String.class, String.class);
        this.operationTypeKey = keyMethod.invoke(null, "easyarmorstands", "edit");
        Method createOperationTypeMethod = this.operationTypeRegistry.getClass().getMethod("createOperationType", this.keyClass, Boolean.TYPE);
        this.operationType = (OperationType)createOperationTypeMethod.invoke((Object)this.operationTypeRegistry, this.operationTypeKey, true);
        this.operationTypeRegistry.registerOperationType(this.operationType);
    }

    private void unregisterOperationType() throws ReflectiveOperationException {
        Method unregisterOperationTypeMethod = this.operationTypeRegistry.getClass().getMethod("unregisterOperationType", this.keyClass);
        unregisterOperationTypeMethod.invoke((Object)this.operationTypeRegistry, this.operationTypeKey);
        this.operationType = null;
    }

    @Override
    public void reload() {
    }
}

