/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.history.action;

import java.util.UUID;
import me.m56738.easyarmorstands.EasyArmorStandsPlugin;
import me.m56738.easyarmorstands.api.element.DestroyableElement;
import me.m56738.easyarmorstands.api.element.Element;
import me.m56738.easyarmorstands.api.element.ElementReference;
import me.m56738.easyarmorstands.api.element.ElementType;
import me.m56738.easyarmorstands.api.element.EntityElementReference;
import me.m56738.easyarmorstands.api.property.PropertyContainer;
import me.m56738.easyarmorstands.api.property.PropertyMap;
import me.m56738.easyarmorstands.context.ChangeContext;
import me.m56738.easyarmorstands.history.action.Action;
import org.jetbrains.annotations.NotNull;

abstract class ElementPresenceAction
implements Action {
    private final PropertyContainer properties;
    private ElementReference reference;

    public ElementPresenceAction(@NotNull Element element) {
        this.properties = new PropertyMap(element.getProperties());
        this.reference = element.getReference();
    }

    protected boolean create(ChangeContext context) {
        ElementType type = this.reference.getType();
        if (!context.canCreateElement(type, this.properties)) {
            return false;
        }
        Element element = type.createElement(this.properties);
        if (element == null) {
            return false;
        }
        UUID oldId = this.getId(this.reference);
        this.reference = element.getReference();
        UUID newId = this.getId(this.reference);
        if (oldId != null && newId != null) {
            EasyArmorStandsPlugin.getInstance().getHistoryManager().onEntityReplaced(oldId, newId);
        }
        return true;
    }

    protected boolean destroy(ChangeContext context) {
        if (this.reference == null) {
            return false;
        }
        Element element = this.reference.getElement();
        if (!(element instanceof DestroyableElement)) {
            return false;
        }
        DestroyableElement destroyableElement = (DestroyableElement)element;
        if (!context.canDestroyElement(destroyableElement)) {
            return false;
        }
        destroyableElement.destroy();
        return true;
    }

    @Override
    public void onEntityReplaced(@NotNull UUID oldId, @NotNull UUID newId) {
        if (this.reference != null) {
            this.reference.onEntityReplaced(oldId, newId);
        }
    }

    private UUID getId(ElementReference reference) {
        if (reference instanceof EntityElementReference) {
            return ((EntityElementReference)reference).getId();
        }
        return null;
    }

    public ElementType getType() {
        return this.reference.getType();
    }
}

