/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.element;

import java.util.UUID;
import me.m56738.easyarmorstands.EasyArmorStandsPlugin;
import me.m56738.easyarmorstands.api.element.EntityElement;
import me.m56738.easyarmorstands.api.element.EntityElementReference;
import me.m56738.easyarmorstands.api.element.EntityElementType;
import me.m56738.easyarmorstands.capability.lookup.LookupCapability;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityElementReferenceImpl<E extends Entity>
implements EntityElementReference<E> {
    private final EntityElementType<E> type;
    private final UUID worldId;
    private final Vector position;
    private UUID id;

    public EntityElementReferenceImpl(EntityElementType<E> type, Entity entity) {
        this.type = type;
        this.worldId = entity.getWorld().getUID();
        this.position = entity.getLocation().toVector();
        this.id = entity.getUniqueId();
    }

    @Override
    @NotNull
    public EntityElementType<E> getType() {
        return this.type;
    }

    @Override
    @Nullable
    public EntityElement<E> getElement() {
        Entity entity;
        World world = Bukkit.getWorld((UUID)this.worldId);
        Chunk chunk = null;
        if (world != null) {
            chunk = world.getChunkAt(this.position.toLocation(world));
        }
        if ((entity = EasyArmorStandsPlugin.getInstance().getCapability(LookupCapability.class).getEntity(this.id, chunk)) == null) {
            return null;
        }
        return this.type.getElement((Entity)this.type.getEntityClass().cast(entity));
    }

    @Override
    public void onEntityReplaced(@NotNull UUID oldId, @NotNull UUID newId) {
        if (this.id.equals(oldId)) {
            this.id = newId;
        }
    }

    @Override
    @NotNull
    public UUID getId() {
        return this.id;
    }
}

