/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.element;

import me.m56738.easyarmorstands.api.element.Element;
import me.m56738.easyarmorstands.api.element.ElementSpawnRequest;
import me.m56738.easyarmorstands.api.element.ElementType;
import me.m56738.easyarmorstands.api.property.PropertyMap;
import me.m56738.easyarmorstands.api.property.type.EntityPropertyTypes;
import me.m56738.easyarmorstands.command.sender.EasPlayer;
import me.m56738.easyarmorstands.history.action.ElementCreateAction;
import me.m56738.easyarmorstands.session.SessionImpl;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElementSpawnRequestImpl
implements ElementSpawnRequest {
    private final PropertyMap properties = new PropertyMap();
    private final ElementType type;
    private EasPlayer player;

    public ElementSpawnRequestImpl(ElementType type) {
        this.type = type;
    }

    @Override
    @NotNull
    public ElementType getType() {
        return this.type;
    }

    @Override
    @Nullable
    public Player getPlayer() {
        return this.player != null ? this.player.get() : null;
    }

    @Override
    public void setPlayer(@Nullable Player player) {
        this.player = player != null ? new EasPlayer(player) : null;
    }

    @Override
    @NotNull
    public PropertyMap getProperties() {
        return this.properties;
    }

    @Override
    @Nullable
    public Element spawn() {
        PropertyMap properties = new PropertyMap();
        if (this.player != null) {
            Location originLocation = this.type.isSpawnedAtEyeHeight() ? this.player.get().getEyeLocation() : this.player.get().getLocation();
            Vector offset = originLocation.getDirection().multiply(2);
            if (!this.player.get().isFlying()) {
                offset.setY(0);
            }
            Location location = originLocation.add(offset);
            location.setYaw(location.getYaw() + 180.0f);
            SessionImpl session = this.player.session();
            if (session != null) {
                location.setX(session.snapper().snapPosition(location.getX()));
                location.setY(session.snapper().snapPosition(location.getY()));
                location.setZ(session.snapper().snapPosition(location.getZ()));
                location.setYaw((float)session.snapper().snapAngle(location.getYaw()));
                location.setPitch((float)session.snapper().snapAngle(location.getPitch()));
            }
            properties.put(EntityPropertyTypes.LOCATION, location);
        }
        this.type.applyDefaultProperties(properties);
        properties.putAll(this.properties);
        if (this.player != null && !this.player.canCreateElement(this.type, properties)) {
            return null;
        }
        Element element = this.type.createElement(properties);
        if (element == null) {
            return null;
        }
        if (this.player != null) {
            this.player.history().push(new ElementCreateAction(element));
            this.player.clipboard().handleAutoApply(element, this.player);
        }
        return element;
    }
}

