/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.editor.node;

import java.util.Objects;
import me.m56738.easyarmorstands.EasyArmorStandsPlugin;
import me.m56738.easyarmorstands.api.element.Element;
import me.m56738.easyarmorstands.api.element.ElementDiscoveryEntry;
import me.m56738.easyarmorstands.api.element.SelectableElement;
import me.m56738.easyarmorstands.capability.visibility.VisibilityCapability;
import me.m56738.easyarmorstands.editor.node.EntityElementDiscoverySource;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class EntityElementDiscoveryEntry
implements ElementDiscoveryEntry {
    private final EntityElementDiscoverySource source;
    private final Player player;
    private final Entity entity;

    public EntityElementDiscoveryEntry(EntityElementDiscoverySource source, Player player, Entity entity) {
        this.source = source;
        this.player = player;
        this.entity = entity;
    }

    @Override
    public SelectableElement getElement() {
        VisibilityCapability visibilityCapability = EasyArmorStandsPlugin.getInstance().getCapability(VisibilityCapability.class);
        if (visibilityCapability != null && !visibilityCapability.isNotHidden(this.player, this.entity)) {
            return null;
        }
        Element element = this.source.getElement(this.entity);
        if (element instanceof SelectableElement) {
            return (SelectableElement)element;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityElementDiscoveryEntry that = (EntityElementDiscoveryEntry)o;
        return Objects.equals(this.source, that.source) && Objects.equals(this.player, that.player) && Objects.equals(this.entity, that.entity);
    }

    public int hashCode() {
        return Objects.hash(this.source, this.player, this.entity);
    }
}

