/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.editor.node;

import me.m56738.easyarmorstands.api.Axis;
import me.m56738.easyarmorstands.api.editor.Session;
import me.m56738.easyarmorstands.api.editor.context.EnterContext;
import me.m56738.easyarmorstands.api.editor.context.ExitContext;
import me.m56738.easyarmorstands.api.editor.context.UpdateContext;
import me.m56738.easyarmorstands.api.editor.tool.AxisRotateToolSession;
import me.m56738.easyarmorstands.api.particle.CircleParticle;
import me.m56738.easyarmorstands.api.particle.LineParticle;
import me.m56738.easyarmorstands.api.particle.ParticleColor;
import me.m56738.easyarmorstands.editor.node.ToolNode;
import me.m56738.easyarmorstands.editor.node.ValueNode;
import me.m56738.easyarmorstands.lib.cloud.parser.ArgumentParser;
import me.m56738.easyarmorstands.lib.cloud.parser.standard.DoubleParser;
import me.m56738.easyarmorstands.lib.joml.Quaterniondc;
import me.m56738.easyarmorstands.lib.joml.Vector3d;
import me.m56738.easyarmorstands.lib.joml.Vector3dc;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.util.Cursor2D;
import me.m56738.easyarmorstands.util.Util;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class AxisRotateToolNode
extends ToolNode
implements ValueNode<Double> {
    private final Session session;
    private final AxisRotateToolSession toolSession;
    private final double radius;
    private final double length;
    private final CircleParticle circleParticle;
    private final LineParticle axisParticle;
    private final LineParticle cursorLineParticle;
    private final Cursor2D cursor;
    private final Vector3dc position;
    private final Vector3dc direction;
    private final Vector3d initialOffset = new Vector3d();
    private final Vector3d currentOffset = new Vector3d();
    private final Vector3d snappedCursor = new Vector3d();
    private boolean valid;
    private boolean hasManualInput;

    public AxisRotateToolNode(Session session, AxisRotateToolSession toolSession, double radius, double length, Component name, ParticleColor color, Vector3dc position, Quaterniondc rotation, Axis axis) {
        super(session, toolSession, name);
        this.session = session;
        this.toolSession = toolSession;
        this.radius = radius;
        this.length = length;
        double scale = session.getScale(position);
        this.circleParticle = session.particleProvider().createCircle();
        this.circleParticle.setColor(color);
        this.circleParticle.setRadius(radius * scale);
        this.circleParticle.setCenter(position);
        this.circleParticle.setRotation(rotation);
        this.circleParticle.setAxis(axis);
        this.circleParticle.setWidth(0.015625 * scale);
        this.axisParticle = session.particleProvider().createLine();
        this.axisParticle.setColor(color);
        this.axisParticle.setLength(length * scale);
        this.axisParticle.setCenter(position);
        this.axisParticle.setRotation(rotation);
        this.axisParticle.setAxis(axis);
        this.axisParticle.setWidth(0.015625 * scale);
        this.cursorLineParticle = session.particleProvider().createLine();
        this.cursor = new Cursor2D(session);
        this.position = new Vector3d(position);
        this.direction = axis.getDirection().rotate(rotation, new Vector3d());
    }

    @Override
    public void onEnter(@NotNull EnterContext context) {
        this.cursor.start(context, this.position, context.cursorOrDefault(this.position), this.direction);
        this.cursorLineParticle.setFromTo(this.position, this.cursor.get());
        this.session.addParticle(this.circleParticle);
        this.session.addParticle(this.axisParticle);
        this.session.addParticle(this.cursorLineParticle);
        this.valid = false;
        this.hasManualInput = false;
    }

    @Override
    public void onExit(@NotNull ExitContext context) {
        super.onExit(context);
        this.cursor.stop();
        this.session.removeParticle(this.cursorLineParticle);
        this.session.removeParticle(this.axisParticle);
        this.session.removeParticle(this.circleParticle);
    }

    @Override
    public void onUpdate(@NotNull UpdateContext context) {
        this.cursor.update(context);
        double scale = this.session.getScale(this.position);
        this.circleParticle.setRadius(this.radius * scale);
        this.circleParticle.setWidth(0.015625 * scale);
        this.axisParticle.setLength(this.length * scale);
        this.axisParticle.setWidth(0.015625 * scale);
        this.cursorLineParticle.setWidth(0.015625 * scale);
        if (!this.hasManualInput) {
            double angle;
            Vector3dc cursorPosition = this.cursor.get();
            cursorPosition.sub(this.position, this.currentOffset);
            if (this.valid) {
                angle = this.initialOffset.angleSigned(this.currentOffset, this.direction);
                angle = this.toolSession.snapChange(angle, this.session.snapper());
            } else {
                angle = 0.0;
                double minOffset = 0.2;
                if (this.currentOffset.lengthSquared() >= minOffset * minOffset) {
                    this.initialOffset.set(this.currentOffset);
                    this.valid = true;
                }
            }
            this.initialOffset.rotateAxis(angle, this.direction.x(), this.direction.y(), this.direction.z(), this.snappedCursor).normalize(this.currentOffset.length()).add(this.position);
            this.toolSession.setChange(angle);
            this.cursorLineParticle.setFromTo(this.position, this.snappedCursor);
        }
        super.onUpdate(context);
    }

    @Override
    public Component formatValue(Double value) {
        return Util.formatDegrees(value);
    }

    @Override
    public ArgumentParser<CommandSender, Double> getParser() {
        return new DoubleParser<CommandSender>(-360.0, 360.0);
    }

    @Override
    public boolean canSetValue() {
        return this.toolSession.canSetValue(this.session.player());
    }

    @Override
    public void setValue(Double value) {
        this.toolSession.setValue(Math.toRadians(value));
        this.hasManualInput = true;
        this.session.removeParticle(this.cursorLineParticle);
        this.cursor.stop();
    }
}

