/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.display.editor.node;

import me.m56738.easyarmorstands.api.editor.Session;
import me.m56738.easyarmorstands.api.editor.context.AddContext;
import me.m56738.easyarmorstands.api.editor.context.EnterContext;
import me.m56738.easyarmorstands.api.editor.context.ExitContext;
import me.m56738.easyarmorstands.api.editor.context.RemoveContext;
import me.m56738.easyarmorstands.api.editor.context.UpdateContext;
import me.m56738.easyarmorstands.api.particle.BoundingBoxParticle;
import me.m56738.easyarmorstands.api.particle.ParticleColor;
import me.m56738.easyarmorstands.api.property.Property;
import me.m56738.easyarmorstands.api.property.PropertyContainer;
import me.m56738.easyarmorstands.api.property.type.EntityPropertyTypes;
import me.m56738.easyarmorstands.api.util.BoundingBox;
import me.m56738.easyarmorstands.display.api.property.type.DisplayPropertyTypes;
import me.m56738.easyarmorstands.editor.node.PropertyMenuNode;
import me.m56738.easyarmorstands.lib.joml.Vector3d;
import me.m56738.easyarmorstands.lib.joml.Vector3dc;
import me.m56738.easyarmorstands.util.Util;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;

public class DisplayMenuNode
extends PropertyMenuNode {
    private final Session session;
    private final BoundingBoxParticle boxParticle;
    private final Property<Location> locationProperty;
    private final Property<Float> widthProperty;
    private final Property<Float> heightProperty;
    private boolean showBoundingBoxIfInactive;
    private boolean canShow;
    private boolean isVisible;
    private boolean isActive;

    public DisplayMenuNode(Session session, PropertyContainer container) {
        super(session, container);
        this.session = session;
        this.boxParticle = session.particleProvider().createAxisAlignedBox();
        this.locationProperty = container.get(EntityPropertyTypes.LOCATION);
        this.widthProperty = container.get(DisplayPropertyTypes.BOX_WIDTH);
        this.heightProperty = container.get(DisplayPropertyTypes.BOX_HEIGHT);
    }

    @Override
    public void onAdd(@NotNull AddContext context) {
        this.canShow = true;
        this.boxParticle.setColor(ParticleColor.GRAY);
        this.updateBoundingBox();
    }

    @Override
    public void onRemove(@NotNull RemoveContext context) {
        this.canShow = false;
        if (this.isVisible) {
            this.session.removeParticle(this.boxParticle);
            this.isVisible = false;
        }
    }

    @Override
    public void onEnter(@NotNull EnterContext context) {
        this.isActive = true;
        this.boxParticle.setColor(ParticleColor.WHITE);
        this.updateBoundingBox();
        super.onEnter(context);
    }

    @Override
    public void onExit(@NotNull ExitContext context) {
        this.isActive = false;
        this.boxParticle.setColor(ParticleColor.GRAY);
        this.updateBoundingBox();
        super.onExit(context);
    }

    @Override
    public void onUpdate(@NotNull UpdateContext context) {
        this.updateBoundingBox();
        super.onUpdate(context);
    }

    @Override
    public void onInactiveUpdate(@NotNull UpdateContext context) {
        this.updateBoundingBox();
        super.onInactiveUpdate(context);
    }

    private void updateBoundingBox() {
        boolean visible;
        float width = this.widthProperty.getValue().floatValue();
        float height = this.heightProperty.getValue().floatValue();
        Location location = this.locationProperty.getValue();
        Vector3d position = Util.toVector3d(location);
        boolean bl = visible = this.canShow && width != 0.0f && height != 0.0f && (this.isActive || this.showBoundingBoxIfInactive);
        if (visible) {
            this.boxParticle.setBoundingBox(BoundingBox.of((Vector3dc)position, width, height));
        }
        if (this.isVisible != visible) {
            this.isVisible = visible;
            if (visible) {
                this.session.addParticle(this.boxParticle);
            } else {
                this.session.removeParticle(this.boxParticle);
            }
        }
    }

    public boolean isShowBoundingBoxIfInactive() {
        return this.showBoundingBoxIfInactive;
    }

    public void setShowBoundingBoxIfInactive(boolean showBoundingBoxIfInactive) {
        this.showBoundingBoxIfInactive = showBoundingBoxIfInactive;
    }
}

