/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.display.command.value;

import java.util.Locale;
import me.m56738.easyarmorstands.api.Axis;
import me.m56738.easyarmorstands.command.sender.EasCommandSender;
import me.m56738.easyarmorstands.command.value.ScaleAxisCommand;
import me.m56738.easyarmorstands.display.api.property.type.DisplayPropertyTypes;
import me.m56738.easyarmorstands.lib.cloud.Command;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.NotNull;

public class DisplayScaleAxisCommand
extends ScaleAxisCommand {
    private final String axisName;

    public DisplayScaleAxisCommand(Axis axis) {
        super(DisplayPropertyTypes.SCALE, axis);
        this.axisName = axis.getName().toLowerCase(Locale.ROOT);
    }

    @Override
    @NotNull
    public String formatCommand(@NotNull Float value) {
        return "/eas scale " + this.axisName + " " + value;
    }

    @Override
    public @NonNull Command.Builder<EasCommandSender> applyToCommandBuilder(@NonNull Command.Builder<EasCommandSender> builder) {
        return builder.literal("scale", new String[0]).literal(this.axisName, new String[0]);
    }
}

