/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.config.serializer;

import java.lang.reflect.Type;
import me.m56738.easyarmorstands.api.menu.Menu;
import me.m56738.easyarmorstands.api.menu.MenuFactory;
import me.m56738.easyarmorstands.api.menu.MenuSlotFactory;
import me.m56738.easyarmorstands.lib.configurate.ConfigurationNode;
import me.m56738.easyarmorstands.lib.configurate.serialize.SerializationException;
import me.m56738.easyarmorstands.lib.configurate.serialize.TypeSerializer;
import me.m56738.easyarmorstands.menu.factory.MenuFactoryBuilderImpl;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MenuFactorySerializer
implements TypeSerializer<MenuFactory> {
    @Override
    public MenuFactory deserialize(Type type, ConfigurationNode node) throws SerializationException {
        MenuFactoryBuilderImpl factory = new MenuFactoryBuilderImpl();
        factory.setTitleTemplate(node.node("title").getString());
        factory.setHeight(node.node("height").getInt());
        factory.setBackground(node.node("background").get(MenuSlotFactory.class));
        for (ConfigurationNode configurationNode : node.node("slots").childrenMap().values()) {
            if (!configurationNode.node("enabled").getBoolean(true)) continue;
            MenuSlotFactory slotFactory = configurationNode.get(MenuSlotFactory.class);
            int row = configurationNode.node("row").getInt();
            int column = configurationNode.node("column").getInt();
            MenuSlotFactory old = factory.setSlot(Menu.index(row, column), slotFactory);
            if (old == null) continue;
            throw new SerializationException(configurationNode.node(new Object[0]), (Type)((Object)MenuSlotFactory.class), "Multiple entries for slot [" + row + ", " + column + "]");
        }
        return factory.build();
    }

    @Override
    public void serialize(Type type, @Nullable MenuFactory obj, ConfigurationNode node) throws SerializationException {
        throw new SerializationException(new UnsupportedOperationException());
    }
}

