/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.command.value;

import me.m56738.easyarmorstands.api.Axis;
import me.m56738.easyarmorstands.api.property.Property;
import me.m56738.easyarmorstands.api.property.PropertyContainer;
import me.m56738.easyarmorstands.api.property.type.PropertyType;
import me.m56738.easyarmorstands.command.processor.PropertyPermissionPredicate;
import me.m56738.easyarmorstands.command.sender.EasCommandSender;
import me.m56738.easyarmorstands.command.value.ValueCommand;
import me.m56738.easyarmorstands.lib.cloud.description.Description;
import me.m56738.easyarmorstands.lib.cloud.minecraft.extras.RichDescription;
import me.m56738.easyarmorstands.lib.cloud.parser.ParserDescriptor;
import me.m56738.easyarmorstands.lib.cloud.parser.standard.FloatParser;
import me.m56738.easyarmorstands.lib.cloud.permission.Permission;
import me.m56738.easyarmorstands.lib.joml.Vector3f;
import me.m56738.easyarmorstands.lib.joml.Vector3fc;
import me.m56738.easyarmorstands.lib.kyori.adventure.audience.Audience;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.format.TextColor;
import me.m56738.easyarmorstands.message.Message;
import me.m56738.easyarmorstands.util.Util;
import org.jetbrains.annotations.NotNull;

public abstract class ScaleAxisCommand
implements ValueCommand<Float> {
    private final PropertyType<Vector3fc> type;
    private final Axis axis;

    public ScaleAxisCommand(PropertyType<Vector3fc> type, Axis axis) {
        this.type = type;
        this.axis = axis;
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        return this.type.getName().append(Component.space()).append(Component.text(this.axis.getName(), TextColor.color(this.axis.getColor())));
    }

    @Override
    @NotNull
    public Permission getPermission() {
        return PropertyPermissionPredicate.createPermission(this.type);
    }

    @Override
    @NotNull
    public ParserDescriptor<EasCommandSender, Float> getParser() {
        return FloatParser.floatParser(0.0f);
    }

    @Override
    @NotNull
    public Description getShowDescription() {
        return RichDescription.translatable("easyarmorstands.command.description.scale.show");
    }

    @Override
    @NotNull
    public Description getSetterDescription() {
        return RichDescription.translatable("easyarmorstands.command.description.scale.set");
    }

    @Override
    public boolean isSupported(@NotNull PropertyContainer properties) {
        return properties.getOrNull(this.type) != null;
    }

    @Override
    @NotNull
    public Float getValue(@NotNull PropertyContainer properties) {
        return Float.valueOf(this.axis.getValue(properties.get(this.type).getValue()));
    }

    @Override
    public boolean setValue(@NotNull PropertyContainer properties, @NotNull Float value) {
        Property<Vector3fc> property = properties.get(this.type);
        Vector3f scale = new Vector3f(property.getValue());
        this.axis.setValue(scale, value.floatValue());
        return property.setValue(scale);
    }

    @Override
    @NotNull
    public Component formatValue(@NotNull Float value) {
        return Util.formatScale(value.floatValue());
    }

    @Override
    public void sendSuccess(@NotNull Audience audience, @NotNull Float value) {
        audience.sendMessage(Message.success("easyarmorstands.success.changed-scale.axis", Component.text(this.axis.getName()), Util.formatScale(value.floatValue())));
    }

    @Override
    public void sendNotSupported(@NotNull Audience audience) {
        audience.sendMessage(Message.error("easyarmorstands.error.scale-unsupported"));
    }
}

