/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.command.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import me.m56738.easyarmorstands.api.element.Element;
import me.m56738.easyarmorstands.api.property.PropertyContainer;
import me.m56738.easyarmorstands.context.ChangeContext;
import me.m56738.easyarmorstands.group.property.GroupPropertyContainer;
import me.m56738.easyarmorstands.property.TrackedPropertyContainer;
import org.jetbrains.annotations.NotNull;

public class ElementSelection {
    private final Collection<Element> elements;

    public ElementSelection(Collection<Element> elements) {
        this.elements = Collections.unmodifiableCollection(elements);
    }

    @NotNull
    public Collection<Element> elements() {
        return this.elements;
    }

    @NotNull
    public PropertyContainer properties(ChangeContext context) {
        if (this.elements.size() == 1) {
            return new TrackedPropertyContainer(this.elements.iterator().next(), context);
        }
        ArrayList<PropertyContainer> containers = new ArrayList<PropertyContainer>(this.elements.size());
        for (Element element : this.elements) {
            containers.add(new TrackedPropertyContainer(element, context));
        }
        return new GroupPropertyContainer(containers);
    }
}

