/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.capability;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import me.m56738.easyarmorstands.capability.Capability;
import me.m56738.easyarmorstands.capability.CapabilityProvider;
import me.m56738.easyarmorstands.capability.Priority;
import org.bukkit.plugin.Plugin;

public class CapabilityLoader {
    private final Plugin plugin;
    private final Map<Class<?>, Entry> capabilities = new TreeMap<Class, Entry>(Comparator.comparing(Class::getName));

    public CapabilityLoader(Plugin plugin, ClassLoader classLoader) {
        this.plugin = plugin;
        for (CapabilityProvider provider : ServiceLoader.load(CapabilityProvider.class, classLoader)) {
            try {
                for (Type genericInterface : provider.getClass().getGenericInterfaces()) {
                    Type typeArgument;
                    ParameterizedType parameterizedType;
                    Type rawType;
                    if (!(genericInterface instanceof ParameterizedType) || (rawType = (parameterizedType = (ParameterizedType)genericInterface).getRawType()) != CapabilityProvider.class || !((typeArgument = parameterizedType.getActualTypeArguments()[0]) instanceof Class)) continue;
                    this.register((Class)typeArgument, provider);
                }
            }
            catch (Throwable e) {
                plugin.getLogger().log(Level.SEVERE, "Failed to load " + provider.getClass().getName(), e);
            }
        }
    }

    public void load() {
        for (Entry entry : this.capabilities.values()) {
            entry.load(this.plugin);
            if (entry.instance != null || entry.capability.optional()) continue;
            throw new IllegalStateException("Required capability not supported: " + entry.capability.name());
        }
    }

    public boolean isCapability(Class<?> type) {
        return this.capabilities.containsKey(type);
    }

    public Collection<Entry> getCapabilities() {
        return Collections.unmodifiableCollection(this.capabilities.values());
    }

    public <T> T get(Class<T> capability) {
        Entry entry = this.capabilities.get(capability);
        if (entry == null) {
            return null;
        }
        return (T)entry.instance;
    }

    public <T> void register(Class<T> capability, CapabilityProvider<T> provider) {
        Entry entry = this.capabilities.computeIfAbsent(capability, x$0 -> new Entry((Class)x$0));
        entry.add(provider);
    }

    public static class Entry {
        private final Class<?> type;
        private final Capability capability;
        private final EnumMap<Priority, Set<CapabilityProvider<?>>> providers = new EnumMap(Priority.class);
        private CapabilityProvider<?> provider;
        private Object instance;
        private int attempts;

        private Entry(Class<?> type) {
            this.type = type;
            this.capability = type.getAnnotation(Capability.class);
            if (this.capability == null) {
                throw new RuntimeException("Capability is not annotated: " + type.getName());
            }
            for (Priority priority : Priority.values()) {
                this.providers.put(priority, new HashSet());
            }
        }

        public Class<?> getType() {
            return this.type;
        }

        public String getName() {
            return this.capability.name();
        }

        public CapabilityProvider<?> getProvider() {
            return this.provider;
        }

        public Object getInstance() {
            return this.instance;
        }

        public int getAttempts() {
            return this.attempts;
        }

        public synchronized void add(CapabilityProvider<?> provider) {
            this.providers.get((Object)provider.getPriority()).add(provider);
        }

        public synchronized void load(Plugin plugin) {
            this.instance = null;
            this.attempts = 0;
            for (Priority priority : Priority.values()) {
                for (CapabilityProvider<?> provider : this.providers.get((Object)priority)) {
                    ++this.attempts;
                    try {
                        if (!provider.isSupported()) continue;
                        this.provider = provider;
                        this.instance = provider.create(plugin);
                        return;
                    }
                    catch (Throwable e) {
                        plugin.getLogger().log(Level.SEVERE, "Failed to process " + provider.getClass().getName(), e);
                    }
                }
            }
        }
    }
}

