/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.api.particle;

import me.m56738.easyarmorstands.api.Axis;
import me.m56738.easyarmorstands.api.particle.ColoredParticle;
import me.m56738.easyarmorstands.lib.joml.Quaterniond;
import me.m56738.easyarmorstands.lib.joml.Quaterniondc;
import me.m56738.easyarmorstands.lib.joml.Vector3d;
import me.m56738.easyarmorstands.lib.joml.Vector3dc;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.NonExtendable
public interface LineParticle
extends ColoredParticle {
    default public void setFromTo(@NotNull Vector3dc from, @NotNull Vector3dc to) {
        Vector3d delta = to.sub(from, new Vector3d());
        if (delta.lengthSquared() < 1.0E-4) {
            this.setCenter(from);
            this.setRotation(new Quaterniond());
            this.setLength(0.0);
            this.setOffset(0.0);
            return;
        }
        Quaterniond rotation = new Quaterniond().rotationTo(this.getAxis().getDirection(), delta);
        double length = delta.length();
        this.setCenter(from);
        this.setRotation(rotation);
        this.setLength(length);
        this.setOffset(length / 2.0);
    }

    @NotNull
    public Vector3dc getCenter();

    public void setCenter(@NotNull Vector3dc var1);

    @NotNull
    public Axis getAxis();

    public void setAxis(@NotNull Axis var1);

    public double getWidth();

    public void setWidth(double var1);

    @NotNull
    public Quaterniondc getRotation();

    public void setRotation(@NotNull Quaterniondc var1);

    public double getLength();

    public void setLength(double var1);

    public double getOffset();

    public void setOffset(double var1);
}

