/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.api.editor.tool;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import me.m56738.easyarmorstands.api.Axis;
import me.m56738.easyarmorstands.api.editor.Snapper;
import me.m56738.easyarmorstands.api.editor.tool.AxisMoveTool;
import me.m56738.easyarmorstands.api.editor.tool.AxisMoveToolSession;
import me.m56738.easyarmorstands.api.editor.tool.MoveTool;
import me.m56738.easyarmorstands.api.editor.tool.MoveToolSession;
import me.m56738.easyarmorstands.lib.joml.Quaterniondc;
import me.m56738.easyarmorstands.lib.joml.Vector3d;
import me.m56738.easyarmorstands.lib.joml.Vector3dc;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SimpleAxisMoveTool
implements AxisMoveTool {
    public static final NumberFormat OFFSET_FORMAT = new DecimalFormat("+0.0000;-0.0000");
    private final MoveTool moveTool;
    private final Axis axis;

    SimpleAxisMoveTool(MoveTool moveTool, Axis axis) {
        this.moveTool = moveTool;
        this.axis = axis;
    }

    @Override
    @NotNull
    public Vector3dc getPosition() {
        return this.moveTool.getPosition();
    }

    @Override
    @NotNull
    public Quaterniondc getRotation() {
        return this.moveTool.getRotation();
    }

    @Override
    @NotNull
    public Axis getAxis() {
        return this.axis;
    }

    @Override
    @NotNull
    public AxisMoveToolSession start() {
        return new AxisMoveToolSessionImpl((MoveToolSession)this.moveTool.start());
    }

    @Override
    public boolean canUse(@NotNull Player player) {
        return this.moveTool.canUse(player);
    }

    private class AxisMoveToolSessionImpl
    implements AxisMoveToolSession {
        private final MoveToolSession moveToolSession;
        private final Vector3dc direction;
        private double change;

        public AxisMoveToolSessionImpl(MoveToolSession moveToolSession) {
            this.moveToolSession = moveToolSession;
            this.direction = SimpleAxisMoveTool.this.axis.getDirection().rotate(SimpleAxisMoveTool.this.getRotation(), new Vector3d());
        }

        @Override
        public void setChange(double change) {
            this.change = change;
            this.moveToolSession.setChange(this.direction.mul(change, new Vector3d()));
        }

        @Override
        public double snapChange(double change, @NotNull Snapper context) {
            return context.snapOffset(change);
        }

        @Override
        public void revert() {
            this.moveToolSession.revert();
        }

        @Override
        public void commit(@Nullable Component description) {
            this.moveToolSession.commit(description);
        }

        @Override
        public boolean isValid() {
            return this.moveToolSession.isValid();
        }

        @Override
        @Nullable
        public Component getStatus() {
            return Component.text(OFFSET_FORMAT.format(this.change));
        }

        @Override
        @Nullable
        public Component getDescription() {
            return this.moveToolSession.getDescription();
        }

        @Override
        public boolean canSetValue(Player player) {
            return this.moveToolSession.canSetPosition(player);
        }
    }
}

