/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.api.editor.tool;

import me.m56738.easyarmorstands.api.editor.Snapper;
import me.m56738.easyarmorstands.api.editor.tool.ScaleTool;
import me.m56738.easyarmorstands.api.editor.tool.ScaleToolSession;
import me.m56738.easyarmorstands.api.editor.tool.ToolContext;
import me.m56738.easyarmorstands.api.property.Property;
import me.m56738.easyarmorstands.api.property.PropertyContainer;
import me.m56738.easyarmorstands.api.util.EasConversion;
import me.m56738.easyarmorstands.api.util.EasFormat;
import me.m56738.easyarmorstands.lib.joml.Math;
import me.m56738.easyarmorstands.lib.joml.Quaterniondc;
import me.m56738.easyarmorstands.lib.joml.Vector3dc;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ScalarScaleTool
implements ScaleTool {
    private final ToolContext context;
    private final PropertyContainer properties;
    private final Property<Location> positionProperty;
    private final Property<Double> scaleProperty;
    private final double minScale;
    private final double maxScale;

    ScalarScaleTool(ToolContext context, PropertyContainer properties, Property<Location> positionProperty, Property<Double> scaleProperty, double minScale, double maxScale) {
        this.context = context;
        this.properties = properties;
        this.positionProperty = positionProperty;
        this.scaleProperty = scaleProperty;
        this.minScale = minScale;
        this.maxScale = maxScale;
    }

    @Override
    @NotNull
    public Vector3dc getPosition() {
        return this.context.position().getPosition();
    }

    @Override
    @NotNull
    public Quaterniondc getRotation() {
        return this.context.rotation().getRotation();
    }

    @Override
    @NotNull
    public ScaleToolSession start() {
        return new SessionImpl();
    }

    @Override
    public boolean canUse(@NotNull Player player) {
        return this.scaleProperty.canChange(player);
    }

    private class SessionImpl
    implements ScaleToolSession {
        private final Location originalLocation;
        private final double originalScale;
        private final double originalEffectiveScale;
        private final Vector3dc offset;
        private double scale;

        public SessionImpl() {
            this.originalLocation = (Location)ScalarScaleTool.this.positionProperty.getValue();
            this.originalScale = (Double)ScalarScaleTool.this.scaleProperty.getValue();
            this.originalEffectiveScale = this.getEffectiveScale(this.originalScale);
            this.offset = EasConversion.fromBukkit(this.originalLocation.toVector()).sub(ScalarScaleTool.this.getPosition());
            this.scale = this.originalScale;
        }

        private double getEffectiveScale(double scale) {
            return Math.clamp(0.0625, 16.0, scale);
        }

        private void updatePosition() {
            double delta = this.getEffectiveScale(this.scale) / this.originalEffectiveScale - 1.0;
            ScalarScaleTool.this.positionProperty.setValue(this.originalLocation.clone().add(this.offset.x() * delta, this.offset.y() * delta, this.offset.z() * delta));
        }

        @Override
        public void setChange(double change) {
            this.scale = Math.clamp(ScalarScaleTool.this.minScale, ScalarScaleTool.this.maxScale, this.originalEffectiveScale * change);
            ScalarScaleTool.this.scaleProperty.setValue(this.scale);
            this.updatePosition();
        }

        @Override
        public double snapChange(double change, @NotNull Snapper context) {
            change *= this.originalEffectiveScale;
            change = context.snapOffset(change);
            return change /= this.originalEffectiveScale;
        }

        @Override
        public void setValue(double value) {
            this.scale = Math.clamp(ScalarScaleTool.this.minScale, ScalarScaleTool.this.maxScale, value);
            ScalarScaleTool.this.scaleProperty.setValue(this.scale);
            this.updatePosition();
        }

        @Override
        public void revert() {
            ScalarScaleTool.this.positionProperty.setValue(this.originalLocation);
            ScalarScaleTool.this.scaleProperty.setValue(this.originalScale);
        }

        @Override
        public void commit(@Nullable Component description) {
            ScalarScaleTool.this.properties.commit(description);
        }

        @Override
        public boolean isValid() {
            return ScalarScaleTool.this.properties.isValid();
        }

        @Override
        @Nullable
        public Component getStatus() {
            return EasFormat.formatScale(this.scale);
        }

        @Override
        @Nullable
        public Component getDescription() {
            return null;
        }
    }
}

