/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.api.editor.tool;

import me.m56738.easyarmorstands.api.Axis;
import me.m56738.easyarmorstands.api.editor.Snapper;
import me.m56738.easyarmorstands.api.editor.tool.AxisRotateTool;
import me.m56738.easyarmorstands.api.editor.tool.AxisRotateToolSession;
import me.m56738.easyarmorstands.api.editor.tool.ToolContext;
import me.m56738.easyarmorstands.api.property.Property;
import me.m56738.easyarmorstands.api.property.PropertyContainer;
import me.m56738.easyarmorstands.api.util.EasConversion;
import me.m56738.easyarmorstands.api.util.EasFormat;
import me.m56738.easyarmorstands.lib.joml.Quaterniondc;
import me.m56738.easyarmorstands.lib.joml.Vector3d;
import me.m56738.easyarmorstands.lib.joml.Vector3dc;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LocationYawRotateTool
implements AxisRotateTool {
    private final ToolContext context;
    private final PropertyContainer properties;
    private final Property<Location> locationProperty;

    LocationYawRotateTool(ToolContext context, PropertyContainer properties, Property<Location> locationProperty) {
        this.context = context;
        this.properties = properties;
        this.locationProperty = locationProperty;
    }

    @Override
    @NotNull
    public Vector3dc getPosition() {
        return this.context.position().getPosition();
    }

    @Override
    @NotNull
    public Quaterniondc getRotation() {
        return this.context.rotation().getRotation();
    }

    @Override
    @NotNull
    public Axis getAxis() {
        return Axis.Y;
    }

    @Override
    @NotNull
    public AxisRotateToolSession start() {
        return new SessionImpl();
    }

    @Override
    public boolean canUse(@NotNull Player player) {
        return this.locationProperty.canChange(player);
    }

    private class SessionImpl
    implements AxisRotateToolSession {
        private final Location originalLocation;
        private final Vector3dc originalOffset;
        private final Vector3d offsetChange = new Vector3d();

        public SessionImpl() {
            this.originalLocation = ((Location)LocationYawRotateTool.this.locationProperty.getValue()).clone();
            this.originalOffset = EasConversion.fromBukkit(this.originalLocation.toVector()).sub(LocationYawRotateTool.this.getPosition());
        }

        @Override
        public void setChange(double change) {
            this.originalOffset.rotateY(change, this.offsetChange).sub(this.originalOffset);
            Location location = this.originalLocation.clone();
            location.add(this.offsetChange.x(), this.offsetChange.y(), this.offsetChange.z());
            location.setYaw(location.getYaw() - (float)Math.toDegrees(change));
            LocationYawRotateTool.this.locationProperty.setValue(location);
        }

        @Override
        public double snapChange(double change, @NotNull Snapper context) {
            double original = Math.toRadians(this.originalLocation.getYaw());
            change -= original;
            change = context.snapAngle(change);
            return change += original;
        }

        @Override
        public void setValue(double value) {
            this.setChange(Math.toRadians(this.originalLocation.getYaw()) - value);
        }

        @Override
        public void revert() {
            LocationYawRotateTool.this.locationProperty.setValue(this.originalLocation);
        }

        @Override
        public void commit(@Nullable Component description) {
            LocationYawRotateTool.this.properties.commit(description);
        }

        @Override
        public boolean isValid() {
            return LocationYawRotateTool.this.properties.isValid();
        }

        @Override
        @Nullable
        public Component getStatus() {
            return EasFormat.formatDegrees(((Location)LocationYawRotateTool.this.locationProperty.getValue()).getYaw());
        }

        @Override
        @Nullable
        public Component getDescription() {
            return Component.translatable("easyarmorstands.history.rotate-yaw");
        }
    }
}

