/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.m56738.easyarmorstands.adapter.EntityPlaceAdapter;
import me.m56738.easyarmorstands.addon.AddonManager;
import me.m56738.easyarmorstands.api.EasyArmorStands;
import me.m56738.easyarmorstands.api.EasyArmorStandsInitializer;
import me.m56738.easyarmorstands.api.editor.Session;
import me.m56738.easyarmorstands.api.element.Element;
import me.m56738.easyarmorstands.api.element.ElementSpawnRequest;
import me.m56738.easyarmorstands.api.element.ElementType;
import me.m56738.easyarmorstands.api.element.EntityElement;
import me.m56738.easyarmorstands.api.element.EntityElementReference;
import me.m56738.easyarmorstands.api.element.EntityElementType;
import me.m56738.easyarmorstands.api.menu.ColorPickerContext;
import me.m56738.easyarmorstands.api.menu.Menu;
import me.m56738.easyarmorstands.api.menu.MenuFactory;
import me.m56738.easyarmorstands.api.menu.MenuProvider;
import me.m56738.easyarmorstands.api.menu.MenuSlotTypeRegistry;
import me.m56738.easyarmorstands.api.property.type.PropertyTypeRegistry;
import me.m56738.easyarmorstands.api.region.RegionPrivilegeManager;
import me.m56738.easyarmorstands.capability.CapabilityLoader;
import me.m56738.easyarmorstands.capability.command.CommandCapability;
import me.m56738.easyarmorstands.capability.handswap.SwapHandItemsCapability;
import me.m56738.easyarmorstands.capability.mannequin.MannequinCapability;
import me.m56738.easyarmorstands.capability.tool.ToolCapability;
import me.m56738.easyarmorstands.clipboard.Clipboard;
import me.m56738.easyarmorstands.clipboard.ClipboardListener;
import me.m56738.easyarmorstands.clipboard.ClipboardManager;
import me.m56738.easyarmorstands.color.ColorAxisChangeSlotType;
import me.m56738.easyarmorstands.color.ColorAxisSlotType;
import me.m56738.easyarmorstands.color.ColorIndicatorSlotType;
import me.m56738.easyarmorstands.color.ColorPresetSlotType;
import me.m56738.easyarmorstands.color.ColorSlot;
import me.m56738.easyarmorstands.command.ClipboardCommands;
import me.m56738.easyarmorstands.command.GlobalCommands;
import me.m56738.easyarmorstands.command.HistoryCommands;
import me.m56738.easyarmorstands.command.PropertyCommands;
import me.m56738.easyarmorstands.command.SessionCommands;
import me.m56738.easyarmorstands.command.annotation.PropertyPermission;
import me.m56738.easyarmorstands.command.parser.NodeValueArgumentParser;
import me.m56738.easyarmorstands.command.processor.ClipboardInjector;
import me.m56738.easyarmorstands.command.processor.ClipboardProcessor;
import me.m56738.easyarmorstands.command.processor.ElementInjector;
import me.m56738.easyarmorstands.command.processor.ElementProcessor;
import me.m56738.easyarmorstands.command.processor.ElementSelectionInjector;
import me.m56738.easyarmorstands.command.processor.ElementSelectionProcessor;
import me.m56738.easyarmorstands.command.processor.GroupProcessor;
import me.m56738.easyarmorstands.command.processor.PropertyPermissionBuilderModifier;
import me.m56738.easyarmorstands.command.processor.SessionInjector;
import me.m56738.easyarmorstands.command.processor.SessionProcessor;
import me.m56738.easyarmorstands.command.processor.ValueNodeInjector;
import me.m56738.easyarmorstands.command.requirement.CommandRequirementBuilderModifier;
import me.m56738.easyarmorstands.command.requirement.CommandRequirementPostProcessor;
import me.m56738.easyarmorstands.command.requirement.ElementRequirement;
import me.m56738.easyarmorstands.command.requirement.ElementSelectionRequirement;
import me.m56738.easyarmorstands.command.requirement.RequireElement;
import me.m56738.easyarmorstands.command.requirement.RequireElementSelection;
import me.m56738.easyarmorstands.command.requirement.RequireSession;
import me.m56738.easyarmorstands.command.requirement.SessionRequirement;
import me.m56738.easyarmorstands.command.sender.EasCommandSender;
import me.m56738.easyarmorstands.command.sender.EasPlayer;
import me.m56738.easyarmorstands.command.util.ElementSelection;
import me.m56738.easyarmorstands.config.EasConfig;
import me.m56738.easyarmorstands.config.serializer.EasSerializers;
import me.m56738.easyarmorstands.config.version.Transformations;
import me.m56738.easyarmorstands.config.version.game.GameVersionTransformation;
import me.m56738.easyarmorstands.editor.node.ValueNode;
import me.m56738.easyarmorstands.element.ArmorStandElementProvider;
import me.m56738.easyarmorstands.element.ArmorStandElementType;
import me.m56738.easyarmorstands.element.ElementSpawnRequestImpl;
import me.m56738.easyarmorstands.element.EntityElementListener;
import me.m56738.easyarmorstands.element.EntityElementProviderRegistryImpl;
import me.m56738.easyarmorstands.element.EntityElementReferenceImpl;
import me.m56738.easyarmorstands.element.MannequinElementProvider;
import me.m56738.easyarmorstands.element.MannequinElementType;
import me.m56738.easyarmorstands.element.SimpleEntityElementProvider;
import me.m56738.easyarmorstands.history.History;
import me.m56738.easyarmorstands.history.HistoryManager;
import me.m56738.easyarmorstands.lib.bstats.bukkit.Metrics;
import me.m56738.easyarmorstands.lib.cloud.CommandManager;
import me.m56738.easyarmorstands.lib.cloud.annotations.AnnotationParser;
import me.m56738.easyarmorstands.lib.cloud.exception.InvalidCommandSenderException;
import me.m56738.easyarmorstands.lib.cloud.minecraft.extras.MinecraftExceptionHandler;
import me.m56738.easyarmorstands.lib.cloud.minecraft.extras.RichDescription;
import me.m56738.easyarmorstands.lib.cloud.minecraft.extras.parser.TextColorParser;
import me.m56738.easyarmorstands.lib.configurate.CommentedConfigurationNode;
import me.m56738.easyarmorstands.lib.configurate.ConfigurateException;
import me.m56738.easyarmorstands.lib.configurate.loader.HeaderMode;
import me.m56738.easyarmorstands.lib.configurate.serialize.SerializationException;
import me.m56738.easyarmorstands.lib.configurate.serialize.TypeSerializerCollection;
import me.m56738.easyarmorstands.lib.configurate.util.MapFactories;
import me.m56738.easyarmorstands.lib.configurate.yaml.NodeStyle;
import me.m56738.easyarmorstands.lib.configurate.yaml.YamlConfigurationLoader;
import me.m56738.easyarmorstands.lib.geantyref.TypeToken;
import me.m56738.easyarmorstands.lib.gizmo.bukkit.api.BukkitGizmos;
import me.m56738.easyarmorstands.lib.kyori.adventure.key.Key;
import me.m56738.easyarmorstands.lib.kyori.adventure.platform.bukkit.BukkitAudiences;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.format.TextColor;
import me.m56738.easyarmorstands.menu.ColorPickerMenuContext;
import me.m56738.easyarmorstands.menu.ColorPicketContextWrapper;
import me.m56738.easyarmorstands.menu.ElementMenuContext;
import me.m56738.easyarmorstands.menu.MenuListener;
import me.m56738.easyarmorstands.menu.MenuProviderImpl;
import me.m56738.easyarmorstands.menu.MenuSlotTypeRegistryImpl;
import me.m56738.easyarmorstands.menu.SimpleMenuContext;
import me.m56738.easyarmorstands.menu.slot.ArmorStandPartSlotType;
import me.m56738.easyarmorstands.menu.slot.ArmorStandPositionSlotType;
import me.m56738.easyarmorstands.menu.slot.ArmorStandSpawnSlotType;
import me.m56738.easyarmorstands.menu.slot.BackgroundSlotType;
import me.m56738.easyarmorstands.menu.slot.ColorPickerSlotType;
import me.m56738.easyarmorstands.menu.slot.DestroySlotType;
import me.m56738.easyarmorstands.menu.slot.EntityCopySlotType;
import me.m56738.easyarmorstands.menu.slot.FallbackSlotType;
import me.m56738.easyarmorstands.menu.slot.MannequinSpawnSlotType;
import me.m56738.easyarmorstands.menu.slot.PropertySlotType;
import me.m56738.easyarmorstands.message.Message;
import me.m56738.easyarmorstands.message.MessageManager;
import me.m56738.easyarmorstands.permission.Permissions;
import me.m56738.easyarmorstands.property.type.DefaultPropertyTypes;
import me.m56738.easyarmorstands.property.type.PropertyTypeRegistryImpl;
import me.m56738.easyarmorstands.region.RegionListenerManager;
import me.m56738.easyarmorstands.session.SessionImpl;
import me.m56738.easyarmorstands.session.SessionListener;
import me.m56738.easyarmorstands.session.SessionManagerImpl;
import me.m56738.easyarmorstands.session.SkeletonLoginListener;
import me.m56738.easyarmorstands.update.UpdateManager;
import me.m56738.easyarmorstands.util.ReflectionUtil;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class EasyArmorStandsPlugin
extends JavaPlugin
implements EasyArmorStands {
    private static EasyArmorStandsPlugin instance;
    private final CapabilityLoader loader = new CapabilityLoader((Plugin)this, this.getClassLoader());
    private final Map<Class<?>, MenuFactory> entityMenuFactories = new HashMap();
    private EasConfig config;
    private MenuFactory spawnMenuFactory;
    private MenuFactory colorPickerFactory;
    private MessageManager messageManager;
    private AddonManager addonManager;
    private RegionListenerManager regionPrivilegeManager;
    private PropertyTypeRegistryImpl propertyTypeRegistry;
    private EntityElementProviderRegistryImpl entityElementProviderRegistry;
    private MenuSlotTypeRegistryImpl menuSlotTypeRegistry;
    private MenuProviderImpl menuProvider;
    private SessionManagerImpl sessionManager;
    private HistoryManager historyManager;
    private ClipboardManager clipboardManager;
    private UpdateManager updateManager;
    private BukkitAudiences adventure;
    private BukkitGizmos gizmos;
    private CommandManager<EasCommandSender> commandManager;
    private AnnotationParser<EasCommandSender> annotationParser;

    public static EasyArmorStandsPlugin getInstance() {
        return instance;
    }

    public Path getConfigFolder() {
        return this.getDataFolder().toPath();
    }

    public void onLoad() {
        Permissions.registerAll();
        instance = this;
        EasyArmorStandsInitializer.initialize(this);
        this.loader.load();
        this.propertyTypeRegistry = new PropertyTypeRegistryImpl();
        new DefaultPropertyTypes(this.propertyTypeRegistry);
        ArmorStandElementType armorStandElementType = new ArmorStandElementType();
        this.entityElementProviderRegistry = new EntityElementProviderRegistryImpl();
        this.entityElementProviderRegistry.register(new ArmorStandElementProvider(armorStandElementType));
        this.entityElementProviderRegistry.register(new SimpleEntityElementProvider());
        this.menuSlotTypeRegistry = new MenuSlotTypeRegistryImpl();
        this.menuSlotTypeRegistry.register(new EntityCopySlotType());
        this.menuSlotTypeRegistry.register(new ArmorStandPartSlotType());
        this.menuSlotTypeRegistry.register(new ArmorStandPositionSlotType());
        this.menuSlotTypeRegistry.register(new ArmorStandSpawnSlotType(armorStandElementType));
        this.menuSlotTypeRegistry.register(new BackgroundSlotType());
        this.menuSlotTypeRegistry.register(new ColorAxisSlotType());
        this.menuSlotTypeRegistry.register(new ColorAxisChangeSlotType());
        this.menuSlotTypeRegistry.register(new ColorIndicatorSlotType());
        this.menuSlotTypeRegistry.register(new ColorPickerSlotType());
        this.menuSlotTypeRegistry.register(new ColorPresetSlotType());
        this.menuSlotTypeRegistry.register(new DestroySlotType());
        this.menuSlotTypeRegistry.register(new PropertySlotType());
        this.menuSlotTypeRegistry.register(new FallbackSlotType(Key.key("easyarmorstands", "spawn/item_display")));
        this.menuSlotTypeRegistry.register(new FallbackSlotType(Key.key("easyarmorstands", "spawn/block_display")));
        this.menuSlotTypeRegistry.register(new FallbackSlotType(Key.key("easyarmorstands", "spawn/text_display")));
        this.menuSlotTypeRegistry.register(new FallbackSlotType(Key.key("easyarmorstands", "spawn/interaction")));
        this.menuSlotTypeRegistry.register(new FallbackSlotType(Key.key("easyarmorstands", "spawn/mannequin")));
        this.menuSlotTypeRegistry.register(new FallbackSlotType(Key.key("easyarmorstands:traincarts/model_browser")));
        this.menuSlotTypeRegistry.register(new FallbackSlotType(Key.key("easyarmorstands:headdatabase")));
        MannequinCapability mannequinCapability = this.getCapability(MannequinCapability.class);
        if (mannequinCapability != null) {
            MannequinElementType<?> type = mannequinCapability.createElementType();
            this.entityElementProviderRegistry.register(new MannequinElementProvider(type, mannequinCapability));
            this.menuSlotTypeRegistry.register(new MannequinSpawnSlotType(type));
        }
        this.menuProvider = new MenuProviderImpl();
        this.loadConfig();
        this.messageManager = new MessageManager((Plugin)this);
        this.messageManager.load(this.config);
        this.regionPrivilegeManager = new RegionListenerManager();
        this.addonManager = new AddonManager(this.getLogger());
        this.addonManager.load(this.getClassLoader());
    }

    public void onEnable() {
        new Metrics((Plugin)this, 17911);
        this.adventure = BukkitAudiences.create((Plugin)this);
        this.gizmos = BukkitGizmos.create((Plugin)this);
        this.loadProperties();
        this.sessionManager = new SessionManagerImpl();
        this.historyManager = new HistoryManager();
        this.clipboardManager = new ClipboardManager();
        SessionListener sessionListener = new SessionListener(this, this.sessionManager);
        this.getServer().getPluginManager().registerEvents((Listener)new MenuListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)sessionListener, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.historyManager, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ClipboardListener(this.clipboardManager), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new EntityElementListener(), (Plugin)this);
        if (!ReflectionUtil.isDeprecated(PlayerLoginEvent.class)) {
            this.getServer().getPluginManager().registerEvents((Listener)new SkeletonLoginListener(this.sessionManager), (Plugin)this);
        }
        this.getServer().getScheduler().runTaskTimer((Plugin)this, this.sessionManager::update, 0L, 1L);
        this.getServer().getScheduler().runTaskTimer((Plugin)this, sessionListener::update, 0L, 1L);
        SwapHandItemsCapability swapHandItemsCapability = this.getCapability(SwapHandItemsCapability.class);
        if (swapHandItemsCapability != null) {
            swapHandItemsCapability.addListener(sessionListener);
        }
        this.commandManager = this.getCapability(CommandCapability.class).createCommandManager();
        MinecraftExceptionHandler.createNative().defaultArgumentParsingHandler().defaultInvalidSyntaxHandler().defaultNoPermissionHandler().defaultCommandExecutionHandler().defaultInvalidSenderHandler().handler(InvalidCommandSenderException.class, (sender, e) -> Message.error("easyarmorstands.error.not-a-player")).registerTo(this.commandManager);
        this.commandManager.parameterInjectorRegistry().registerInjector(ValueNode.class, new ValueNodeInjector()).registerInjector(SessionImpl.class, new SessionInjector()).registerInjector(Clipboard.class, new ClipboardInjector()).registerInjector(Element.class, new ElementInjector()).registerInjector(ElementSelection.class, new ElementSelectionInjector());
        this.commandManager.parserRegistry().registerNamedParserSupplier("node_value", p -> new NodeValueArgumentParser());
        this.commandManager.parserRegistry().registerParserSupplier(TypeToken.get(TextColor.class), p -> new TextColorParser());
        this.commandManager.registerCommandPreProcessor(new ElementSelectionProcessor());
        this.commandManager.registerCommandPreProcessor(new GroupProcessor());
        this.commandManager.registerCommandPreProcessor(new ElementProcessor());
        this.commandManager.registerCommandPreProcessor(new SessionProcessor());
        this.commandManager.registerCommandPreProcessor(new ClipboardProcessor());
        this.commandManager.registerCommandPostProcessor(new CommandRequirementPostProcessor());
        this.annotationParser = new AnnotationParser<EasCommandSender>(this.commandManager, EasCommandSender.class);
        this.annotationParser.descriptionMapper(RichDescription::translatable);
        this.annotationParser.registerBuilderModifier(RequireSession.class, new CommandRequirementBuilderModifier<RequireSession>(a -> new SessionRequirement()));
        this.annotationParser.registerBuilderModifier(RequireElement.class, new CommandRequirementBuilderModifier<RequireElement>(a -> new ElementRequirement()));
        this.annotationParser.registerBuilderModifier(RequireElementSelection.class, new CommandRequirementBuilderModifier<RequireElementSelection>(a -> new ElementSelectionRequirement()));
        this.annotationParser.registerBuilderModifier(PropertyPermission.class, new PropertyPermissionBuilderModifier());
        this.annotationParser.parse(new GlobalCommands(this.commandManager, sessionListener));
        this.annotationParser.parse(new SessionCommands());
        this.annotationParser.parse(new HistoryCommands());
        this.annotationParser.parse(new ClipboardCommands());
        PropertyCommands.register(this.commandManager);
        if (ReflectionUtil.hasClass("org.bukkit.event.entity.EntityPlaceEvent")) {
            try {
                EntityPlaceAdapter.enable((Plugin)this, sessionListener);
            }
            catch (ReflectiveOperationException e2) {
                this.getLogger().log(Level.WARNING, "Failed to listen to entity place event", e2);
            }
        }
        this.addonManager.enable();
        this.loadUpdateChecker();
        this.loadMenuTemplates();
        for (CapabilityLoader.Entry entry : this.loader.getCapabilities()) {
            Object capability = entry.getInstance();
            if (!(capability instanceof Listener)) continue;
            this.getServer().getPluginManager().registerEvents((Listener)capability, (Plugin)this);
        }
    }

    private Callable<BufferedReader> getDefaultConfigSource(String name) {
        return () -> {
            InputStream resource = this.getResource(name);
            if (resource == null) {
                throw new FileNotFoundException(name);
            }
            return new BufferedReader(new InputStreamReader(resource, StandardCharsets.UTF_8));
        };
    }

    public void onDisable() {
        if (this.sessionManager != null) {
            this.sessionManager.stopAllSessions();
        }
        if (this.addonManager != null) {
            this.addonManager.disable();
        }
        if (this.regionPrivilegeManager != null) {
            this.regionPrivilegeManager.unregisterAll();
        }
        Permissions.unregisterAll();
        if (this.gizmos != null) {
            this.gizmos.close();
        }
        if (this.adventure != null) {
            this.adventure.close();
        }
    }

    public void reload() {
        this.loadConfig();
        this.loadProperties();
        this.messageManager.load(this.config);
        this.loadMenuTemplates();
        this.addonManager.reload();
    }

    private void loadConfig() {
        this.loadConfig("config.yml", new ConfigProcessor(){

            @Override
            public void process(CommentedConfigurationNode node) throws ConfigurateException {
                GameVersionTransformation.config().apply(node);
                Transformations.config().apply(node);
            }

            @Override
            public void apply(CommentedConfigurationNode node) throws ConfigurateException {
                EasyArmorStandsPlugin.this.config = node.get(EasConfig.class);
            }
        });
    }

    private void loadProperties() {
        this.loadConfig("properties.yml", new ConfigProcessor(){

            @Override
            public void process(CommentedConfigurationNode node) throws ConfigurateException {
                GameVersionTransformation.properties().apply(node);
                Transformations.properties().apply(node);
            }

            @Override
            public void apply(CommentedConfigurationNode node) throws ConfigurateException {
                EasyArmorStandsPlugin.this.propertyTypeRegistry.load(node);
            }
        });
    }

    private void loadConfig(String name, ConfigProcessor configProcessor) {
        try {
            this.loadMergedConfig(name, configProcessor);
            return;
        }
        catch (ConfigurateException e) {
            this.getLogger().severe("Failed to load " + name + ": " + e.getMessage());
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to load " + name, e);
        }
        try {
            this.loadDefaultConfig(name, configProcessor);
        }
        catch (ConfigurateException e) {
            this.getLogger().log(Level.SEVERE, "Failed to load default " + name, e);
        }
    }

    private void loadUpdateChecker() {
        if (this.getDescription().getVersion().endsWith("-SNAPSHOT")) {
            return;
        }
        if (this.config.updateCheck.enabled) {
            if (this.updateManager == null) {
                this.updateManager = new UpdateManager((Plugin)this, this.adventure, "easyarmorstands.update.notify", 108349);
            }
        } else if (this.updateManager != null) {
            this.updateManager.unregister();
            this.updateManager = null;
        }
    }

    private void loadMenuTemplates() {
        this.spawnMenuFactory = this.loadMenuTemplate("spawn");
        this.colorPickerFactory = this.loadMenuTemplate("color_picker");
        MenuFactory defaultEntityMenuFactory = this.loadMenuTemplate("entity/default");
        MenuFactory livingEntityMenuFactory = this.loadMenuTemplate("entity/living");
        for (EntityType type : EntityType.values()) {
            MenuFactory factory = this.loadMenuTemplate("entity/type/" + type.name().toLowerCase(Locale.ROOT));
            if (factory == null) {
                factory = type.isAlive() ? livingEntityMenuFactory : defaultEntityMenuFactory;
            }
            this.entityMenuFactories.put(type.getEntityClass(), factory);
        }
    }

    public MenuFactory loadMenuTemplate(String name) {
        try {
            return this.loadMenuTemplate(name, false);
        }
        catch (ConfigurateException e) {
            this.getLogger().log(Level.SEVERE, "Failed to load menu \"" + name + "\": " + e.getMessage());
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to load menu \"" + name + "\"", e);
        }
        try {
            return this.loadMenuTemplate(name, true);
        }
        catch (ConfigurateException e) {
            this.getLogger().log(Level.SEVERE, "Failed to load default menu \"" + name + "\": " + e.getMessage());
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to load default menu \"" + name + "\"", e);
        }
        return null;
    }

    private MenuFactory loadMenuTemplate(String name, boolean fallback) throws ConfigurateException {
        return this.loadMenuTemplate(name, new LinkedHashSet<String>(), fallback).get(MenuFactory.class);
    }

    private CommentedConfigurationNode loadMenuTemplate(String name, Set<String> seen, boolean fallback) throws ConfigurateException {
        List<String> parents;
        if (!seen.add(name)) {
            String description = Stream.concat(seen.stream(), Stream.of(name)).collect(Collectors.joining(", ", "[", "]"));
            throw new SerializationException("Cycle detected: " + description);
        }
        ConfigProcessor processor = new ConfigProcessor(){

            @Override
            public void process(CommentedConfigurationNode node) throws ConfigurateException {
                GameVersionTransformation.menu().apply(node);
            }

            @Override
            public void apply(CommentedConfigurationNode node) {
            }
        };
        String configName = "menu/" + name + ".yml";
        CommentedConfigurationNode node = fallback ? this.loadDefaultConfig(configName, processor) : this.loadMergedConfig(configName, processor);
        CommentedConfigurationNode parentsNode = (CommentedConfigurationNode)node.node(new Object[]{"parent"});
        if (!parentsNode.virtual() && (parents = parentsNode.getList(String.class)) != null) {
            for (String parent : parents) {
                node.mergeFrom(this.loadMenuTemplate(parent, new LinkedHashSet<String>(seen), fallback));
            }
        }
        return node;
    }

    private CommentedConfigurationNode loadMergedConfig(String name, final ConfigProcessor configProcessor) throws ConfigurateException {
        CommentedConfigurationNode defaultNode = this.loadDefaultConfig(name, new ConfigProcessor(){

            @Override
            public void process(CommentedConfigurationNode node) throws ConfigurateException {
                configProcessor.process(node);
            }

            @Override
            public void apply(CommentedConfigurationNode node) {
            }
        });
        YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().nodeStyle(NodeStyle.BLOCK).indent(2).headerMode(HeaderMode.PRESET)).defaultOptions(o -> o.serializers(b -> b.registerAll(EasSerializers.serializers())).mapFactory(MapFactories.sortedNatural()).header(defaultNode.options().header()).shouldCopyDefaults(false))).path(this.getConfigFolder().resolve(name))).build();
        CommentedConfigurationNode node = (CommentedConfigurationNode)loader.load();
        if (!node.empty()) {
            configProcessor.process(node);
        }
        node.mergeFrom(defaultNode);
        configProcessor.apply(node);
        if (!node.empty()) {
            loader.save(node);
        }
        return node;
    }

    private CommentedConfigurationNode loadDefaultConfig(String name, ConfigProcessor configProcessor) throws ConfigurateException {
        YamlConfigurationLoader defaultLoader = ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().defaultOptions(o -> o.serializers(b -> b.registerAll(EasSerializers.serializers())))).source(this.getDefaultConfigSource(name))).build();
        CommentedConfigurationNode node = (CommentedConfigurationNode)defaultLoader.load();
        if (!node.empty()) {
            configProcessor.process(node);
        }
        configProcessor.apply(node);
        return node;
    }

    public History getHistory(Player player) {
        return this.historyManager.getHistory(player);
    }

    public Clipboard getClipboard(Player player) {
        return this.clipboardManager.getClipboard(player);
    }

    @Contract(pure=true)
    public <T> T getCapability(Class<T> type) {
        return this.loader.get(type);
    }

    public CapabilityLoader getCapabilityLoader() {
        return this.loader;
    }

    public HistoryManager getHistoryManager() {
        return this.historyManager;
    }

    public BukkitAudiences getAdventure() {
        return this.adventure;
    }

    public BukkitGizmos getGizmos() {
        return this.gizmos;
    }

    public CommandManager<EasCommandSender> getCommandManager() {
        return this.commandManager;
    }

    public AnnotationParser<EasCommandSender> getAnnotationParser() {
        return this.annotationParser;
    }

    public ItemStack createTool(Locale locale) {
        ItemStack item = this.config.editor.tool.render(locale);
        ToolCapability toolCapability = this.getCapability(ToolCapability.class);
        if (toolCapability != null) {
            toolCapability.configureTool(item);
        }
        return item;
    }

    public boolean isTool(ItemStack item) {
        if (item == null) {
            return false;
        }
        ToolCapability toolCapability = EasyArmorStandsPlugin.getInstance().getCapability(ToolCapability.class);
        if (toolCapability != null) {
            return toolCapability.isTool(item);
        }
        if (!Objects.equals(this.config.editor.tool.getType(), item.getType())) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        return meta.hasDisplayName();
    }

    public EasConfig getConfiguration() {
        return this.config;
    }

    public Menu createSpawnMenu(Player player) {
        return this.spawnMenuFactory.createMenu(new SimpleMenuContext(new EasPlayer(player)));
    }

    public Menu createColorPicker(Player player, ColorPickerContext context) {
        ColorPicketContextWrapper contextWrapper = new ColorPicketContextWrapper(context);
        ColorPickerMenuContext menuContext = new ColorPickerMenuContext(new EasPlayer(player), contextWrapper);
        Menu menu = this.colorPickerFactory.createMenu(menuContext);
        contextWrapper.subscribe(() -> menu.updateItems(slot -> slot instanceof ColorSlot));
        return menu;
    }

    public void openMenu(Player player, Session session, MenuFactory factory, Element element) {
        Menu menu = factory.createMenu(new ElementMenuContext(new EasPlayer(player), session, element));
        player.openInventory(menu.getInventory());
    }

    public void openEntityMenu(Player player, Session session, EntityElement<?> element) {
        MenuFactory factory = this.entityMenuFactories.get(element.getType().getEntityClass());
        if (factory != null) {
            this.openMenu(player, session, factory, element);
        }
    }

    @Override
    @NotNull
    public EntityElementProviderRegistryImpl entityElementProviderRegistry() {
        return this.entityElementProviderRegistry;
    }

    @Override
    @NotNull
    public MenuSlotTypeRegistry menuSlotTypeRegistry() {
        return Objects.requireNonNull(this.menuSlotTypeRegistry);
    }

    @Override
    @NotNull
    public MenuProvider menuProvider() {
        return Objects.requireNonNull(this.menuProvider);
    }

    @Override
    @NotNull
    public SessionManagerImpl sessionManager() {
        return Objects.requireNonNull(this.sessionManager);
    }

    @Override
    @NotNull
    public ElementSpawnRequest elementSpawnRequest(ElementType type) {
        return new ElementSpawnRequestImpl(type);
    }

    @Override
    @NotNull
    public PropertyTypeRegistry propertyTypeRegistry() {
        return Objects.requireNonNull(this.propertyTypeRegistry);
    }

    @Override
    @NotNull
    public TypeSerializerCollection serializers() {
        return EasSerializers.serializers();
    }

    @Override
    @NotNull
    public RegionPrivilegeManager regionPrivilegeManager() {
        return Objects.requireNonNull(this.regionPrivilegeManager);
    }

    @Override
    @NotNull
    public <E extends Entity> EntityElementReference<E> createReference(EntityElementType<E> type, E entity) {
        return new EntityElementReferenceImpl<E>(type, entity);
    }

    private static interface ConfigProcessor {
        public void process(CommentedConfigurationNode var1) throws ConfigurateException;

        public void apply(CommentedConfigurationNode var1) throws ConfigurateException;
    }
}

