/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.update;

import java.io.IOException;
import java.util.logging.Level;
import me.m56738.easyarmorstands.lib.kyori.adventure.audience.Audience;
import me.m56738.easyarmorstands.lib.kyori.adventure.platform.bukkit.BukkitAudiences;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.event.ClickEvent;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.event.HoverEventSource;
import me.m56738.easyarmorstands.message.Message;
import me.m56738.easyarmorstands.update.SpigotVersionFetcher;
import me.m56738.easyarmorstands.update.UpdateListener;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class UpdateManager {
    private final Plugin plugin;
    private final BukkitAudiences adventure;
    private final String permission;
    private final SpigotVersionFetcher updateChecker;
    private final String spigotUrl;
    private final UpdateListener listener;
    private final BukkitTask timer;
    private String latestVersion;

    public UpdateManager(Plugin plugin, BukkitAudiences adventure, String permission, int id) {
        this.plugin = plugin;
        this.adventure = adventure;
        this.permission = permission;
        this.updateChecker = new SpigotVersionFetcher("https://api.spigotmc.org/simple/0.2/index.php?action=getResource&id=" + id);
        this.spigotUrl = "https://www.spigotmc.org/resources/" + id;
        this.listener = new UpdateListener(this, adventure);
        this.timer = plugin.getServer().getScheduler().runTaskTimerAsynchronously(plugin, this::refresh, 0L, 1728000L);
        plugin.getServer().getPluginManager().registerEvents((Listener)this.listener, plugin);
    }

    public void unregister() {
        HandlerList.unregisterAll((Listener)this.listener);
        this.timer.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        String latestVersion;
        String currentVersion = this.plugin.getDescription().getVersion();
        try {
            latestVersion = this.updateChecker.fetchLatestVersion();
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to check for updates", e);
            return;
        }
        if (latestVersion == null || latestVersion.equals(currentVersion)) {
            return;
        }
        UpdateManager updateManager = this;
        synchronized (updateManager) {
            if (latestVersion.equals(this.latestVersion)) {
                return;
            }
            this.latestVersion = latestVersion;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.hasPermission(this.permission)) continue;
            this.notify(this.adventure.player(player), latestVersion);
        }
        this.plugin.getLogger().info("EasyArmorStands v" + latestVersion + " is available");
        this.plugin.getLogger().info(this.spigotUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(Audience audience) {
        String version;
        UpdateManager updateManager = this;
        synchronized (updateManager) {
            version = this.latestVersion;
        }
        if (version != null) {
            this.notify(audience, version);
        }
    }

    public void notify(Audience audience, String version) {
        audience.sendMessage(Message.warning("easyarmorstands.update.available", Component.text(version)).hoverEvent((HoverEventSource)Message.hover("easyarmorstands.update.click-to-visit")).clickEvent(ClickEvent.openUrl(this.spigotUrl)));
    }
}

