/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.group;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import me.m56738.easyarmorstands.api.editor.Session;
import me.m56738.easyarmorstands.api.element.EditableElement;
import me.m56738.easyarmorstands.group.GroupMember;
import me.m56738.easyarmorstands.lib.joml.Vector3d;
import me.m56738.easyarmorstands.lib.joml.Vector3dc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnmodifiableView;

public class Group {
    private final Session session;
    private final Set<GroupMember> members = new LinkedHashSet<GroupMember>();

    public Group(Session session) {
        this.session = session;
    }

    public void addMember(EditableElement element) {
        this.addMember(new GroupMember(this.session, element));
    }

    public void addMember(GroupMember member) {
        this.members.add(member);
    }

    public void update() {
        this.members.removeIf(m -> !m.isValid());
    }

    public @UnmodifiableView @NotNull Set<GroupMember> getMembers() {
        return Collections.unmodifiableSet(this.members);
    }

    @NotNull
    public Session getSession() {
        return this.session;
    }

    public Vector3dc getAveragePosition() {
        Vector3d temp = new Vector3d();
        Vector3d position = new Vector3d();
        for (GroupMember member : this.members) {
            position.add(member.getBoundingBox().getCenter(temp));
        }
        position.div(this.members.size());
        return position;
    }

    public boolean isValid() {
        return !this.members.isEmpty();
    }
}

