/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.group.property;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Consumer;
import me.m56738.easyarmorstands.api.property.Property;
import me.m56738.easyarmorstands.api.property.PropertyContainer;
import me.m56738.easyarmorstands.api.property.type.PropertyType;
import me.m56738.easyarmorstands.group.property.GroupProperty;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.message.Message;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GroupPropertyContainer
implements PropertyContainer {
    private final List<PropertyContainer> containers;

    public GroupPropertyContainer(Collection<PropertyContainer> containers) {
        this.containers = new ArrayList<PropertyContainer>(containers);
    }

    @Override
    public void forEach(@NotNull Consumer<Property<?>> consumer) {
        LinkedHashMap properties = new LinkedHashMap();
        for (PropertyContainer container : this.containers) {
            container.forEach(property -> properties.computeIfAbsent(property.getType(), GroupProperty::new).addProperty(property));
        }
        for (GroupProperty property2 : properties.values()) {
            consumer.accept(property2);
        }
    }

    @Override
    @Nullable
    public <T> Property<T> getOrNull(@NotNull PropertyType<T> type) {
        GroupProperty<T> property = new GroupProperty<T>(type);
        for (PropertyContainer container : this.containers) {
            Property<T> member = container.getOrNull(type);
            if (member == null) continue;
            property.addProperty(member);
        }
        if (property.isEmpty()) {
            return null;
        }
        return property;
    }

    @Override
    public boolean isValid() {
        for (PropertyContainer container : this.containers) {
            if (!container.isValid()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void commit(@Nullable Component description) {
        for (PropertyContainer container : this.containers) {
            container.commit(description);
        }
    }

    @Override
    public void commit() {
        this.commit(Message.component("easyarmorstands.history.edit-group", Component.text(this.containers.size())));
    }
}

