/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.editor.tool;

import me.m56738.easyarmorstands.api.Axis;
import me.m56738.easyarmorstands.api.editor.tool.AxisMoveTool;
import me.m56738.easyarmorstands.api.editor.tool.AxisRotateTool;
import me.m56738.easyarmorstands.api.editor.tool.AxisScaleTool;
import me.m56738.easyarmorstands.api.editor.tool.MoveTool;
import me.m56738.easyarmorstands.api.editor.tool.ScaleTool;
import me.m56738.easyarmorstands.api.editor.tool.ToolContext;
import me.m56738.easyarmorstands.api.editor.tool.ToolProvider;
import me.m56738.easyarmorstands.api.util.PositionProvider;
import me.m56738.easyarmorstands.api.util.RotationProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DelegateToolProvider
implements ToolProvider {
    private final ToolProvider toolProvider;
    private final PositionProvider positionProvider;
    private final RotationProvider rotationProvider;

    public DelegateToolProvider(ToolProvider toolProvider, PositionProvider positionProvider, RotationProvider rotationProvider) {
        this.toolProvider = toolProvider;
        this.positionProvider = positionProvider != null ? positionProvider : toolProvider.position();
        this.rotationProvider = rotationProvider != null ? rotationProvider : toolProvider.rotation();
    }

    @Override
    @NotNull
    public PositionProvider position() {
        return this.positionProvider;
    }

    @Override
    @NotNull
    public RotationProvider rotation() {
        return this.rotationProvider;
    }

    @Override
    @Nullable
    public MoveTool move(@NotNull ToolContext context) {
        return this.toolProvider.move(context);
    }

    @Override
    @Nullable
    public AxisMoveTool move(@NotNull ToolContext context, @NotNull Axis axis) {
        return this.toolProvider.move(context, axis);
    }

    @Override
    @Nullable
    public AxisRotateTool rotate(@NotNull ToolContext context, @NotNull Axis axis) {
        return this.toolProvider.rotate(context, axis);
    }

    @Override
    @Nullable
    public ScaleTool scale(@NotNull ToolContext context) {
        return this.toolProvider.scale(context);
    }

    @Override
    @Nullable
    public AxisScaleTool scale(@NotNull ToolContext context, @NotNull Axis axis) {
        return this.toolProvider.scale(context, axis);
    }
}

