/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.editor.node;

import me.m56738.easyarmorstands.api.editor.Session;
import me.m56738.easyarmorstands.api.editor.context.EnterContext;
import me.m56738.easyarmorstands.api.editor.context.ExitContext;
import me.m56738.easyarmorstands.api.editor.context.UpdateContext;
import me.m56738.easyarmorstands.api.editor.tool.ScaleToolSession;
import me.m56738.easyarmorstands.api.particle.LineParticle;
import me.m56738.easyarmorstands.api.particle.ParticleColor;
import me.m56738.easyarmorstands.editor.input.tool.ActivateInput;
import me.m56738.easyarmorstands.editor.node.ToolNode;
import me.m56738.easyarmorstands.editor.node.ValueNode;
import me.m56738.easyarmorstands.lib.cloud.parser.ArgumentParser;
import me.m56738.easyarmorstands.lib.cloud.parser.standard.DoubleParser;
import me.m56738.easyarmorstands.lib.joml.Vector3d;
import me.m56738.easyarmorstands.lib.joml.Vector3dc;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.message.Message;
import me.m56738.easyarmorstands.util.Cursor3D;
import me.m56738.easyarmorstands.util.Util;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class ScaleToolNode
extends ToolNode
implements ValueNode<Double> {
    private static final double ACTIVATION_DISTANCE = 0.2;
    protected final Session session;
    protected final ScaleToolSession toolSession;
    private final Vector3dc position;
    private final ParticleColor color;
    private final Cursor3D cursor;
    private final Vector3d delta = new Vector3d();
    private final LineParticle cursorLineParticle;
    private double distance;
    private double initialDistance;
    private boolean canActivate;
    private boolean active;
    private boolean hasManualInput;

    public ScaleToolNode(Session session, ScaleToolSession toolSession, Component name, ParticleColor color, Vector3dc position) {
        super(session, toolSession, name);
        this.session = session;
        this.toolSession = toolSession;
        this.cursorLineParticle = session.particleProvider().createLine();
        this.position = new Vector3d(position);
        this.color = color;
        this.cursor = new Cursor3D(session);
    }

    public void activate() {
        this.initialDistance = this.distance;
        this.active = true;
        this.canActivate = false;
        this.cursorLineParticle.setColor(this.color);
    }

    @Override
    public void onEnter(@NotNull EnterContext context) {
        this.cursor.start(context, context.cursorOrDefault(() -> context.eyeRay().point(1.0)));
        this.distance = this.cursor.get().distance(this.position);
        this.cursorLineParticle.setColor(ParticleColor.GRAY);
        this.cursorLineParticle.setFromTo(this.position, this.cursor.get());
        this.session.addParticle(this.cursorLineParticle);
    }

    @Override
    public void onUpdate(@NotNull UpdateContext context) {
        if (this.canActivate) {
            context.addInput(new ActivateInput(this));
        }
        if (this.hasManualInput) {
            super.onUpdate(context);
            return;
        }
        this.cursor.update(context);
        this.cursor.get().sub(this.position, this.delta);
        this.distance = this.delta.length();
        if (this.active) {
            double change = this.toolSession.snapChange(this.distance / this.initialDistance, this.session.snapper());
            this.distance = change * this.initialDistance;
            this.toolSession.setChange(change);
            this.delta.normalize(this.distance);
        } else {
            this.canActivate = this.distance > 0.2;
            this.cursorLineParticle.setColor(this.canActivate ? ParticleColor.GRAY : ParticleColor.RED);
        }
        this.cursorLineParticle.setFromTo(this.position, this.delta.add(this.position));
        super.onUpdate(context);
    }

    @Override
    protected void updateActionBar(@NotNull UpdateContext context) {
        if (!this.active && !this.hasManualInput) {
            if (this.canActivate) {
                context.setActionBar(Message.component("easyarmorstands.node.scale.right-click"));
            } else {
                context.setActionBar(Message.error("easyarmorstands.node.scale.too-close"));
            }
            return;
        }
        super.updateActionBar(context);
    }

    @Override
    public void onExit(@NotNull ExitContext context) {
        super.onExit(context);
        this.cursor.stop();
        this.session.removeParticle(this.cursorLineParticle);
    }

    @Override
    public Component formatValue(Double value) {
        return Component.text(Util.OFFSET_FORMAT.format(value));
    }

    @Override
    public ArgumentParser<CommandSender, Double> getParser() {
        return new DoubleParser<CommandSender>(0.0, Double.POSITIVE_INFINITY);
    }

    @Override
    public boolean canSetValue() {
        return this.toolSession.canSetValue(this.session.player());
    }

    @Override
    public void setValue(Double value) {
        this.toolSession.setValue(value);
        this.hasManualInput = true;
        this.cursor.stop();
        this.session.removeParticle(this.cursorLineParticle);
    }
}

