/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.api.property;

import java.util.function.Consumer;
import me.m56738.easyarmorstands.api.property.Property;
import me.m56738.easyarmorstands.api.property.PropertyContainer;
import me.m56738.easyarmorstands.api.property.type.PropertyType;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PropertyWrapperContainer
implements PropertyContainer {
    private final PropertyContainer container;

    protected PropertyWrapperContainer(@NotNull PropertyContainer container) {
        this.container = container;
    }

    @NotNull
    protected abstract <T> Property<T> wrap(@NotNull Property<T> var1);

    @Nullable
    private <T> Property<T> wrapOrNull(@Nullable Property<T> property) {
        if (property != null) {
            return this.wrap(property);
        }
        return null;
    }

    @Override
    public void forEach(@NotNull @NotNull Consumer<@NotNull Property<?>> consumer) {
        this.container.forEach(p -> consumer.accept(this.wrap((Property)p)));
    }

    @Override
    @Nullable
    public <T> Property<T> getOrNull(@NotNull PropertyType<T> type) {
        return this.wrapOrNull(this.container.getOrNull(type));
    }

    @Override
    @NotNull
    public <T> Property<T> get(@NotNull PropertyType<T> type) {
        return this.wrap(this.container.get(type));
    }

    @Override
    public boolean isValid() {
        return this.container.isValid();
    }

    @Override
    public void commit(@Nullable Component description) {
        this.container.commit(description);
    }
}

