/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.util;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.UUID;
import me.m56738.easyarmorstands.lib.joml.Math;
import me.m56738.easyarmorstands.lib.joml.Matrix3d;
import me.m56738.easyarmorstands.lib.joml.Matrix3dc;
import me.m56738.easyarmorstands.lib.joml.Matrix4d;
import me.m56738.easyarmorstands.lib.joml.Quaterniond;
import me.m56738.easyarmorstands.lib.joml.Quaterniondc;
import me.m56738.easyarmorstands.lib.joml.Quaternionf;
import me.m56738.easyarmorstands.lib.joml.Vector3d;
import me.m56738.easyarmorstands.lib.joml.Vector3dc;
import me.m56738.easyarmorstands.lib.joml.Vector3fc;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.TextComponent;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.format.NamedTextColor;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.format.TextColor;
import me.m56738.easyarmorstands.lib.kyori.adventure.util.RGBLike;
import me.m56738.easyarmorstands.util.EasMath;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Util {
    public static final NumberFormat POSITION_FORMAT = new DecimalFormat("0.0000");
    public static final NumberFormat OFFSET_FORMAT = new DecimalFormat("+0.0000;-0.0000");
    public static final NumberFormat ANGLE_FORMAT = new DecimalFormat("+0.00\u00b0;-0.00\u00b0");
    public static final NumberFormat SCALE_FORMAT = new DecimalFormat("0.0000");
    public static final Vector3dc ZERO = new Vector3d();
    public static final Quaterniondc IDENTITY = new Quaterniond();
    public static final double PIXEL = 0.0625;
    public static final double LINE_WIDTH = 0.015625;

    private static Component format3D(Vector3dc vector, NumberFormat format) {
        return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text(format.format(vector.x()), (TextColor)NamedTextColor.RED))).append((Component)Component.text(", "))).append((Component)Component.text(format.format(vector.y()), (TextColor)NamedTextColor.GREEN))).append((Component)Component.text(", "))).append((Component)Component.text(format.format(vector.z()), (TextColor)NamedTextColor.BLUE))).build();
    }

    public static Component formatPosition(Vector3dc position) {
        return Util.format3D(position, POSITION_FORMAT);
    }

    public static Component formatLocation(Location location) {
        return Util.formatPosition(Util.toVector3d(location));
    }

    public static Component formatOffset(Vector3dc offset) {
        return Util.format3D(offset, OFFSET_FORMAT);
    }

    public static Component formatDegrees(double degrees) {
        return Component.text(ANGLE_FORMAT.format(EasMath.wrapDegrees(degrees)));
    }

    public static Component formatAngle(double angle) {
        return Util.formatDegrees(Math.toDegrees(angle));
    }

    public static Component formatAngle(Vector3dc angle) {
        return Util.format3D(angle, ANGLE_FORMAT);
    }

    public static Component formatAngle(EulerAngle angle) {
        return Util.formatAngle(new Vector3d(Math.toDegrees(angle.getX()), Math.toDegrees(angle.getY()), Math.toDegrees(angle.getZ())));
    }

    public static Component formatRotation(Quaterniondc rotation) {
        return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text(rotation.x(), (TextColor)NamedTextColor.RED))).append((Component)Component.text(", "))).append((Component)Component.text(rotation.y(), (TextColor)NamedTextColor.GREEN))).append((Component)Component.text(", "))).append((Component)Component.text(rotation.z(), (TextColor)NamedTextColor.BLUE))).append((Component)Component.text(", "))).append((Component)Component.text(rotation.w(), (TextColor)NamedTextColor.WHITE))).build();
    }

    public static Component formatScale(double scale) {
        return Component.text(SCALE_FORMAT.format(scale));
    }

    public static Component formatScale(Vector3dc scale) {
        if (scale.x() == scale.y() && scale.y() == scale.z()) {
            return Util.formatScale(scale.x());
        }
        return Util.format3D(scale, SCALE_FORMAT);
    }

    public static Component formatScale(Vector3fc scale) {
        return Util.formatScale(new Vector3d(scale));
    }

    public static Component formatYawPitch(float yaw, float pitch) {
        return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text(ANGLE_FORMAT.format(yaw)))).append((Component)Component.text(", "))).append((Component)Component.text(ANGLE_FORMAT.format(pitch)))).build();
    }

    public static Quaterniond fromEuler(EulerAngle angle, Quaterniond dest) {
        dest.rotationZYX(-angle.getZ(), -angle.getY(), angle.getX());
        return dest;
    }

    public static EulerAngle toEuler(Quaterniondc rotation) {
        Vector3d dest = new Vector3d();
        rotation.getEulerAnglesZYX(dest);
        return new EulerAngle(dest.x, -dest.y, -dest.z);
    }

    public static Vector3d toVector3d(Location location) {
        return new Vector3d(location.getX(), location.getY(), location.getZ());
    }

    public static Vector3d toVector3d(Location location, Vector3d dest) {
        return dest.set(location.getX(), location.getY(), location.getZ());
    }

    public static Vector3d toVector3d(Vector vector) {
        return new Vector3d(vector.getX(), vector.getY(), vector.getZ());
    }

    public static Matrix4d toMatrix4d(Location location) {
        return new Matrix4d().translation(Util.toVector3d(location)).rotateY(-Math.toRadians(location.getYaw())).rotateX(Math.toRadians(location.getPitch()));
    }

    public static Matrix3dc getRotation(Location location, Matrix3d dest) {
        return dest.rotationZYX(0.0, -Math.toRadians(location.getYaw()), Math.toRadians(location.getPitch()));
    }

    public static Color toColor(RGBLike color) {
        return Color.fromRGB((int)color.red(), (int)color.green(), (int)color.blue());
    }

    public static String getId(UUID uniqueId) {
        return uniqueId.toString().substring(0, 8);
    }

    public static double snap(double value, double increment) {
        if (increment < 0.001) {
            return value;
        }
        return (double)Math.round(value / increment) * increment;
    }

    public static float roundEntityAngle(float angle) {
        return Math.floor(angle * 256.0f / 360.0f) * 360.0f / 256.0f;
    }

    public static float getRoundedYawAngle(float degrees) {
        return -Math.toRadians(Util.roundEntityAngle(degrees));
    }

    public static Quaterniond getRoundedYawRotation(float yaw, Quaterniond dest) {
        return dest.rotationY(Util.getRoundedYawAngle(yaw));
    }

    public static Quaterniond getRoundedYawRotation(Location location, Quaterniond dest) {
        return Util.getRoundedYawRotation(location.getYaw(), dest);
    }

    public static Quaterniond getRoundedYawRotation(Entity entity, Quaterniond dest) {
        return Util.getRoundedYawRotation(entity.getLocation(), dest);
    }

    public static Quaternionf getRoundedYawRotation(float yaw, Quaternionf dest) {
        return dest.rotationY(Util.getRoundedYawAngle(yaw));
    }

    public static Quaternionf getRoundedYawRotation(Location location, Quaternionf dest) {
        return Util.getRoundedYawRotation(location.getYaw(), dest);
    }

    public static Quaternionf getRoundedYawRotation(Entity entity, Quaternionf dest) {
        return Util.getRoundedYawRotation(entity.getLocation(), dest);
    }

    public static Quaterniond getRoundedYawPitchRotation(float yaw, float pitch, Quaterniond dest) {
        return Util.getRoundedYawRotation(yaw, dest).rotateX(Math.toRadians(pitch));
    }

    public static Quaterniond getRoundedYawPitchRotation(Location location, Quaterniond dest) {
        return Util.getRoundedYawPitchRotation(location.getYaw(), location.getPitch(), dest);
    }

    public static Quaterniond getRoundedYawPitchRotation(Entity entity, Quaterniond dest) {
        return Util.getRoundedYawPitchRotation(entity.getLocation(), dest);
    }

    public static Quaternionf getRoundedYawPitchRotation(float yaw, float pitch, Quaternionf dest) {
        return Util.getRoundedYawRotation(yaw, dest).rotateX(Math.toRadians(pitch));
    }

    public static Quaternionf getRoundedYawPitchRotation(Location location, Quaternionf dest) {
        return Util.getRoundedYawPitchRotation(location.getYaw(), location.getPitch(), dest);
    }

    public static Quaternionf getRoundedYawPitchRotation(Entity entity, Quaternionf dest) {
        return Util.getRoundedYawPitchRotation(entity.getLocation(), dest);
    }

    public static <E extends Entity> Class<E> getEntityClass(E entity) {
        return entity.getType().getEntityClass();
    }

    public static Component formatColor(Color color) {
        if (color == null) {
            color = Color.BLACK;
        }
        String red = String.format("%02X", color.getRed());
        String green = String.format("%02X", color.getGreen());
        String blue = String.format("%02X", color.getBlue());
        return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("#").append((Component)Component.text(red, (TextColor)NamedTextColor.RED))).append((Component)Component.text(green, (TextColor)NamedTextColor.GREEN))).append((Component)Component.text(blue, (TextColor)NamedTextColor.BLUE))).build();
    }

    @NotNull
    public static ItemStack getEmptyItem() {
        return new ItemStack(Material.AIR, 0);
    }

    @NotNull
    public static ItemStack wrapItem(@Nullable ItemStack item) {
        if (item == null || item.getType() == Material.AIR || item.getAmount() == 0) {
            return Util.getEmptyItem();
        }
        return item;
    }
}

