/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.session.context;

import me.m56738.easyarmorstands.api.editor.EyeRay;
import me.m56738.easyarmorstands.api.editor.context.ClickContext;
import me.m56738.easyarmorstands.api.editor.input.Input;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClickContextImpl
implements ClickContext {
    private final EyeRay eyeRay;
    private final boolean sneaking;
    private final ClickContext.Type type;
    private final Entity entity;
    private final Block block;

    public ClickContextImpl(EyeRay eyeRay, boolean sneaking, ClickContext.Type type, Entity entity, Block block) {
        this.eyeRay = eyeRay;
        this.sneaking = sneaking;
        this.type = type;
        this.entity = entity;
        this.block = block;
    }

    @Override
    @NotNull
    public EyeRay eyeRay() {
        return this.eyeRay;
    }

    @Override
    public boolean sneaking() {
        return this.sneaking;
    }

    @Override
    @NotNull
    public ClickContext.Type type() {
        return this.type;
    }

    @Override
    @Nullable
    public Entity entity() {
        return this.entity;
    }

    @Override
    @Nullable
    public Block block() {
        return this.block;
    }

    @Override
    public boolean matchesInput(@NotNull Input input) {
        if (input.requireSneak() && !this.sneaking) {
            return false;
        }
        if (!input.allowSneak() && this.sneaking) {
            return false;
        }
        return input.clickType() == this.type;
    }
}

