/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.property.entity;

import java.util.Optional;
import me.m56738.easyarmorstands.api.property.Property;
import me.m56738.easyarmorstands.api.property.type.EntityPropertyTypes;
import me.m56738.easyarmorstands.api.property.type.PropertyType;
import me.m56738.easyarmorstands.capability.component.ComponentCapability;
import me.m56738.easyarmorstands.lib.kyori.adventure.text.Component;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class EntityCustomNameProperty
implements Property<Optional<Component>> {
    private final Entity entity;
    private final ComponentCapability componentCapability;

    public EntityCustomNameProperty(Entity entity, ComponentCapability componentCapability) {
        this.entity = entity;
        this.componentCapability = componentCapability;
    }

    @Override
    @NotNull
    public PropertyType<Optional<Component>> getType() {
        return EntityPropertyTypes.CUSTOM_NAME;
    }

    @Override
    @NotNull
    public Optional<Component> getValue() {
        return Optional.ofNullable(this.componentCapability.getCustomName(this.entity));
    }

    @Override
    public boolean setValue(@NotNull Optional<Component> value) {
        this.componentCapability.setCustomName(this.entity, value.orElse(null));
        return true;
    }
}

