/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.property.button;

import me.m56738.easyarmorstands.EasyArmorStandsPlugin;
import me.m56738.easyarmorstands.api.menu.MenuClick;
import me.m56738.easyarmorstands.api.profile.Profile;
import me.m56738.easyarmorstands.api.property.Property;
import me.m56738.easyarmorstands.api.property.PropertyContainer;
import me.m56738.easyarmorstands.capability.mannequin.MannequinCapability;
import me.m56738.easyarmorstands.item.SimpleItemTemplate;
import me.m56738.easyarmorstands.property.button.PropertyButton;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ProfilePropertyButton
extends PropertyButton<Profile> {
    private final MannequinCapability mannequinCapability = EasyArmorStandsPlugin.getInstance().getCapability(MannequinCapability.class);

    public ProfilePropertyButton(Property<Profile> property, PropertyContainer container, SimpleItemTemplate item) {
        super(property, container, item);
    }

    @Override
    protected SimpleItemTemplate prepareTemplate(SimpleItemTemplate template) {
        Profile profile = (Profile)this.property.getValue();
        ItemStack item = this.mannequinCapability.createProfileItem(profile);
        return super.prepareTemplate(template).withTemplate(item);
    }

    @Override
    public void onClick(@NotNull MenuClick click) {
        Profile profile;
        if (click.isShiftClick()) {
            EasyArmorStandsPlugin.getInstance().getClipboard(click.player()).handlePropertyShiftClick(this.property, click);
            return;
        }
        if (click.isLeftClick()) {
            profile = this.mannequinCapability.getItemProfile(click.cursor());
            if (profile == null) {
                return;
            }
        } else if (click.isRightClick()) {
            profile = Profile.empty();
        } else {
            return;
        }
        click.queueTask(() -> {
            if (this.property.setValue(profile)) {
                this.container.commit();
                click.menu().updateItem(click.index());
            }
        });
    }
}

