/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.easyarmorstands.property.button;

import java.util.List;
import me.m56738.easyarmorstands.api.property.Property;
import me.m56738.easyarmorstands.api.property.PropertyContainer;
import me.m56738.easyarmorstands.api.property.type.ArmorStandPropertyTypes;
import me.m56738.easyarmorstands.item.SimpleItemTemplate;
import me.m56738.easyarmorstands.property.button.BooleanToggleButton;

public class GravityToggleButton
extends BooleanToggleButton {
    private final Property<Boolean> canTickProperty;
    private final List<String> canTickWarning;

    public GravityToggleButton(Property<Boolean> property, PropertyContainer container, SimpleItemTemplate item, List<String> canTickWarning) {
        super(property, container, item);
        this.canTickProperty = container.getOrNull(ArmorStandPropertyTypes.CAN_TICK);
        this.canTickWarning = canTickWarning;
    }

    @Override
    protected SimpleItemTemplate prepareTemplate(SimpleItemTemplate template) {
        template = super.prepareTemplate(template);
        if (this.canTickProperty != null && ((Boolean)this.property.getValue()).booleanValue() && !this.canTickProperty.getValue().booleanValue()) {
            template = template.appendLore(this.canTickWarning);
        }
        return template;
    }

    @Override
    public Boolean getNextValue() {
        boolean value = (Boolean)this.property.getValue();
        if (this.canTickProperty != null && value && !this.canTickProperty.getValue().booleanValue()) {
            return true;
        }
        return !value;
    }

    @Override
    protected boolean setValue(Boolean value) {
        if (!super.setValue(value)) {
            return false;
        }
        if (this.canTickProperty != null && value.booleanValue()) {
            this.canTickProperty.setValue(true);
        }
        return true;
    }
}

